/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class NodeStoreTest {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    private final EphemeralFileSystemRule efs = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.efs);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.efs).around((TestRule)this.testDirectory);
    private NodeStore nodeStore;
    private NeoStores neoStores;
    private IdGeneratorFactory idGeneratorFactory;

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void shouldReadFirstFromSingleRecordDynamicLongArray() {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 23L, 42L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{firstRecord}));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstAsNullFromEmptyDynamicLongArray() {
        Object expectedId = null;
        long[] ids = new long[]{};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{firstRecord}));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals(expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstFromTwoRecordDynamicLongArray() {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, (DynamicRecordAllocator)new ReusableRecordsAllocator(8, new DynamicRecord[]{firstRecord, new DynamicRecord(1L)}));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldCombineProperFiveByteLabelField() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        long nodeId = 0L;
        long labels = 0x8000000001L;
        NodeRecord record = new NodeRecord(nodeId, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setInUse(true);
        record.setLabelField(labels, Collections.emptyList());
        this.nodeStore.updateRecord(record);
        NodeRecord readRecord = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.NORMAL);
        Assert.assertEquals((long)labels, (long)readRecord.getLabelField());
    }

    @Test
    public void shouldKeepRecordLightWhenSettingLabelFieldWithoutDynamicRecords() {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setLabelField(0L, Collections.emptyList());
        Assert.assertTrue((boolean)record.isLight());
    }

    @Test
    public void shouldMarkRecordHeavyWhenSettingLabelFieldWithDynamicRecords() {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        DynamicRecord dynamicRecord = new DynamicRecord(1L);
        record.setLabelField(0x8000000001L, Arrays.asList(dynamicRecord));
        Assert.assertFalse((boolean)record.isLight());
    }

    @Test
    public void shouldTellNodeInUse() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.efs.get();
        NodeStore store = this.newNodeStore((FileSystemAbstraction)fs);
        long exists = store.nextId();
        store.updateRecord(new NodeRecord(exists, false, 10L, 20L, true));
        long deleted = store.nextId();
        store.updateRecord(new NodeRecord(deleted, false, 10L, 20L, true));
        store.updateRecord(new NodeRecord(deleted, false, 10L, 20L, false));
        Assert.assertTrue((boolean)store.isInUse(exists));
        Assert.assertFalse((boolean)store.isInUse(deleted));
        Assert.assertFalse((boolean)store.isInUse(this.nodeStore.recordFormat.getMaxId()));
    }

    @Test
    public void scanningRecordsShouldVisitEachInUseRecordOnce() throws IOException {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        LongHashSet nextRelSet = new LongHashSet();
        for (int i = 0; i < 10000; ++i) {
            int nextRelCandidate = rng.nextInt(0, Integer.MAX_VALUE);
            if (!nextRelSet.add((long)nextRelCandidate)) continue;
            long nodeId = this.nodeStore.nextId();
            NodeRecord record = new NodeRecord(nodeId, false, (long)nextRelCandidate, 20L, true);
            this.nodeStore.updateRecord(record);
            if (rng.nextInt(0, 10) >= 3) continue;
            nextRelSet.remove((long)nextRelCandidate);
            record.setInUse(false);
            this.nodeStore.updateRecord(record);
        }
        Visitor scanner = arg_0 -> NodeStoreTest.lambda$scanningRecordsShouldVisitEachInUseRecordOnce$0((MutableLongSet)nextRelSet, arg_0);
        this.nodeStore.scanAllRecords(scanner);
        Assert.assertTrue((boolean)nextRelSet.isEmpty());
    }

    @Test
    public void shouldCloseStoreFileOnFailureToOpen() {
        final MutableBoolean fired = new MutableBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.efs.get()){

            public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, openMode)){

                    public void readAll(ByteBuffer dst) throws IOException {
                        fired.setValue(true);
                        throw new IOException("Proving a point here");
                    }
                };
            }
        };
        try (PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fs);){
            this.newNodeStore((FileSystemAbstraction)fs);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IOException.class}));
            Assert.assertTrue((boolean)fired.booleanValue());
        }
    }

    @Test
    public void shouldFreeSecondaryUnitIdOfDeletedRecord() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        NodeRecord record = new NodeRecord(5L);
        record.setRequiresSecondaryUnit(true);
        record.setSecondaryUnitId(10L);
        record.setInUse(true);
        this.nodeStore.updateRecord(record);
        this.nodeStore.setHighestPossibleIdInUse(10L);
        record.setInUse(false);
        this.nodeStore.updateRecord(record);
        IdGenerator idGenerator = this.idGeneratorFactory.get(IdType.NODE);
        ((IdGenerator)Mockito.verify((Object)idGenerator)).freeId(5L);
        ((IdGenerator)Mockito.verify((Object)idGenerator)).freeId(10L);
    }

    @Test
    public void shouldFreeSecondaryUnitIdOfShrunkRecord() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        NodeRecord record = new NodeRecord(5L);
        record.setRequiresSecondaryUnit(true);
        record.setSecondaryUnitId(10L);
        record.setInUse(true);
        this.nodeStore.updateRecord(record);
        this.nodeStore.setHighestPossibleIdInUse(10L);
        record.setRequiresSecondaryUnit(false);
        this.nodeStore.updateRecord(record);
        IdGenerator idGenerator = this.idGeneratorFactory.get(IdType.NODE);
        ((IdGenerator)Mockito.verify((Object)idGenerator, (VerificationMode)Mockito.never())).freeId(5L);
        ((IdGenerator)Mockito.verify((Object)idGenerator)).freeId(10L);
    }

    private NodeStore newNodeStore(FileSystemAbstraction fs) throws IOException {
        return this.newNodeStore(fs, pageCacheRule.getPageCache(fs));
    }

    private NodeStore newNodeStore(FileSystemAbstraction fs, PageCache pageCache) throws IOException {
        this.idGeneratorFactory = (IdGeneratorFactory)Mockito.spy((Object)new DefaultIdGeneratorFactory(fs){

            protected IdGenerator instantiate(FileSystemAbstraction fs, File fileName, int grabSize, long maxValue, boolean aggressiveReuse, IdType idType, LongSupplier highId) {
                return (IdGenerator)Mockito.spy((Object)super.instantiate(fs, fileName, grabSize, maxValue, aggressiveReuse, idType, highId));
            }
        });
        StoreFactory factory = new StoreFactory(this.testDirectory.databaseLayout("new"), Config.defaults(), this.idGeneratorFactory, pageCache, fs, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = factory.openAllNeoStores(true);
        this.nodeStore = this.neoStores.getNodeStore();
        return this.nodeStore;
    }

    private static /* synthetic */ boolean lambda$scanningRecordsShouldVisitEachInUseRecordOnce$0(MutableLongSet nextRelSet, NodeRecord record) throws IOException {
        Assert.assertTrue((boolean)nextRelSet.remove(record.getNextRel()));
        return false;
    }
}

