/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ShortStringPropertyEncodeTest {
    private static final int KEY_ID = 0;
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    private NeoStores neoStores;
    private PropertyStore propertyStore;

    @Before
    public void setupStore() {
        this.neoStores = new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), this.storage.pageCache(), this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openNeoStores(true, new StoreType[]{StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING});
        this.propertyStore = this.neoStores.getPropertyStore();
    }

    @After
    public void closeStore() {
        this.neoStores.close();
    }

    @Test
    public void canEncodeEmptyString() {
        this.assertCanEncode("");
    }

    @Test
    public void canEncodeReallyLongString() {
        this.assertCanEncode("                    ");
        this.assertCanEncode("                ");
    }

    @Test
    public void canEncodeFifteenSpaces() {
        this.assertCanEncode("               ");
    }

    @Test
    public void canEncodeNumericalString() {
        this.assertCanEncode("0123456789+,'.-");
        this.assertCanEncode(" ,'.-0123456789");
        this.assertCanEncode("+ '.0123456789-");
        this.assertCanEncode("+, 0123456789.-");
        this.assertCanEncode("+,0123456789' -");
        this.assertCanEncode("+0123456789,'. ");
        this.assertCanEncode("192.168.0.1");
        this.assertCanEncode("127.0.0.1");
        this.assertCanEncode("255.255.255.255");
    }

    @Test
    public void canEncodeTooLongStringsWithCharsInDifferentTables() {
        this.assertCanEncode("____________+");
        this.assertCanEncode("_____+_____");
        this.assertCanEncode("____+____");
        this.assertCanEncode("HELLO world");
        this.assertCanEncode("Hello_World");
    }

    @Test
    public void canEncodeUpToNineEuropeanChars() {
        this.assertCanEncode("f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6n");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6ar");
    }

    @Test
    public void canEncodeEuropeanCharsWithPunctuation() {
        this.assertCanEncode("qHm7 pp3");
        this.assertCanEncode("UKKY3t.gk");
    }

    @Test
    public void canEncodeAlphanumerical() {
        this.assertCanEncode("1234567890");
        this.assertCanEncodeInBothCasings("HelloWor1d");
        this.assertCanEncode("          ");
        this.assertCanEncode("_ _ _ _ _ ");
        this.assertCanEncode("H3Lo_ or1D");
        this.assertCanEncode("q1w2e3r4t+");
    }

    @Test
    public void canEncodeHighUnicode() {
        this.assertCanEncode("\u02ff");
        this.assertCanEncode("hello\u02ff");
    }

    @Test
    public void canEncodeLatin1SpecialChars() {
        this.assertCanEncode("#$#$#$#");
        this.assertCanEncode("$hello#");
    }

    @Test
    public void canEncodeTooLongLatin1String() {
        this.assertCanEncode("#$#$#$#$");
    }

    @Test
    public void canEncodeLowercaseAndUppercaseStringsUpTo12Chars() {
        this.assertCanEncodeInBothCasings("hello world");
        this.assertCanEncode("hello_world");
        this.assertCanEncode("_hello_world");
        this.assertCanEncode("hello::world");
        this.assertCanEncode("hello//world");
        this.assertCanEncode("hello world");
        this.assertCanEncode("http://ok");
        this.assertCanEncode("::::::::");
        this.assertCanEncode(" _.-:/ _.-:/");
    }

    private void assertCanEncodeInBothCasings(String string) {
        this.assertCanEncode(string.toLowerCase());
        this.assertCanEncode(string.toUpperCase());
    }

    private void assertCanEncode(String string) {
        this.encode(string);
    }

    private void encode(String string) {
        PropertyBlock block = new PropertyBlock();
        TextValue expectedValue = Values.stringValue((String)string);
        this.propertyStore.encodeValue(block, 0, (Value)expectedValue);
        Assert.assertEquals((long)0L, (long)block.getValueRecords().size());
        Value readValue = block.getType().value(block, this.propertyStore);
        Assert.assertEquals((Object)expectedValue, (Object)readValue);
    }
}

