/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StoreFactoryTest {
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.testDirectory).around((TestRule)this.pageCacheRule);
    private NeoStores neoStores;
    private IdGeneratorFactory idGeneratorFactory;
    private PageCache pageCache;

    @Before
    public void setUp() {
        FileSystemAbstraction fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(fs);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
    }

    private StoreFactory storeFactory(Config config, OpenOption ... openOptions) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig((Config)config, (DatabaseLayout)databaseLayout, (FileSystemAbstraction)this.fsRule, (PageCache)this.pageCache, (LogProvider)logProvider);
        return new StoreFactory(databaseLayout, config, this.idGeneratorFactory, this.pageCache, this.fsRule.get(), recordFormats, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY, openOptions);
    }

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void shouldHaveSameCreationTimeAndUpgradeTimeOnStartup() {
        this.neoStores = this.storeFactory(Config.defaults(), new OpenOption[0]).openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertThat((Object)metaDataStore.getUpgradeTime(), (Matcher)CoreMatchers.equalTo((Object)metaDataStore.getCreationTime()));
    }

    @Test
    public void shouldHaveSameCommittedTransactionAndUpgradeTransactionOnStartup() {
        this.neoStores = this.storeFactory(Config.defaults(), new OpenOption[0]).openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertEquals((Object)metaDataStore.getUpgradeTransaction(), (Object)metaDataStore.getLastCommittedTransaction());
    }

    @Test
    public void shouldHaveSpecificCountsTrackerForReadOnlyDatabase() throws IOException {
        StoreFactory readOnlyStoreFactory = this.storeFactory(Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true"), new OpenOption[0]);
        this.neoStores = readOnlyStoreFactory.openAllNeoStores(true);
        long lastClosedTransactionId = this.neoStores.getMetaDataStore().getLastClosedTransactionId();
        Assert.assertEquals((long)-1L, (long)this.neoStores.getCounts().rotate(lastClosedTransactionId));
    }

    @Test(expected=StoreNotFoundException.class)
    public void shouldThrowWhenOpeningNonExistingNeoStores() {
        try (NeoStores neoStores = this.storeFactory(Config.defaults(), new OpenOption[0]).openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void shouldDelegateDeletionOptionToStores() {
        StoreFactory storeFactory = this.storeFactory(Config.defaults(), StandardOpenOption.DELETE_ON_CLOSE);
        this.neoStores = storeFactory.openAllNeoStores(true);
        Assert.assertTrue((((EphemeralFileSystemAbstraction)this.fsRule.get()).listFiles(this.testDirectory.databaseDir()).length >= StoreType.values().length ? 1 : 0) != 0);
        this.neoStores.close();
        Assert.assertEquals((long)0L, (long)((EphemeralFileSystemAbstraction)this.fsRule.get()).listFiles(this.testDirectory.databaseDir()).length);
    }

    @Test
    public void shouldHandleStoreConsistingOfOneEmptyFile() throws Exception {
        StoreFactory storeFactory = this.storeFactory(Config.defaults(), new OpenOption[0]);
        FileSystemAbstraction fs = this.fsRule.get();
        fs.create(this.testDirectory.databaseLayout().file("neostore.nodestore.db.labels"));
        storeFactory.openAllNeoStores(true).close();
    }

    @Test
    public void shouldCompleteInitializationOfStoresWithIncompleteHeaders() throws Exception {
        StoreFactory storeFactory = this.storeFactory(Config.defaults(), new OpenOption[0]);
        storeFactory.openAllNeoStores(true).close();
        FileSystemAbstraction fs = this.fsRule.get();
        for (File f : fs.listFiles(this.testDirectory.databaseDir())) {
            fs.truncate(f, 0L);
        }
        storeFactory.openAllNeoStores(true).close();
    }
}

