/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.store.record.SchemaRuleTestBase;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class IndexRuleTest
extends SchemaRuleTestBase {
    @Test
    public void shouldCreateGeneralIndex() {
        IndexDescriptor descriptor = IndexRuleTest.forLabel(10, 30);
        StoreIndexDescriptor indexRule = descriptor.withId(1L);
        MatcherAssert.assertThat((Object)indexRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertFalse((boolean)indexRule.canSupportUniqueConstraint());
        MatcherAssert.assertThat((Object)indexRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        MatcherAssert.assertThat((Object)indexRule, (Matcher)Matchers.equalTo((Object)descriptor));
        MatcherAssert.assertThat((Object)indexRule.providerDescriptor(), (Matcher)Matchers.equalTo((Object)PROVIDER_DESCRIPTOR));
        org.neo4j.test.assertion.Assert.assertException(() -> ((StoreIndexDescriptor)indexRule).getOwningConstraint(), IllegalStateException.class);
        org.neo4j.test.assertion.Assert.assertException(() -> indexRule.withOwningConstraint(Long.valueOf(2L)), IllegalStateException.class);
    }

    @Test
    public void shouldCreateUniqueIndex() {
        IndexDescriptor descriptor = IndexRuleTest.uniqueForLabel(10, 30);
        StoreIndexDescriptor indexRule = descriptor.withId(1L);
        MatcherAssert.assertThat((Object)indexRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertTrue((boolean)indexRule.canSupportUniqueConstraint());
        MatcherAssert.assertThat((Object)indexRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        MatcherAssert.assertThat((Object)indexRule, (Matcher)Matchers.equalTo((Object)descriptor));
        MatcherAssert.assertThat((Object)indexRule.providerDescriptor(), (Matcher)Matchers.equalTo((Object)PROVIDER_DESCRIPTOR));
        MatcherAssert.assertThat((Object)indexRule.getOwningConstraint(), (Matcher)Matchers.equalTo(null));
        StoreIndexDescriptor withConstraint = indexRule.withOwningConstraint(Long.valueOf(2L));
        MatcherAssert.assertThat((Object)withConstraint.getOwningConstraint(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)indexRule.getOwningConstraint(), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void indexRulesAreEqualBasedOnIndexDescriptor() {
        this.assertEqualityByDescriptor(IndexRuleTest.forLabel(10, 30));
        this.assertEqualityByDescriptor(IndexRuleTest.uniqueForLabel(10, 30));
        this.assertEqualityByDescriptor(IndexRuleTest.forLabel(10, 30, 31));
        this.assertEqualityByDescriptor(IndexRuleTest.uniqueForLabel(10, 30, 31));
    }

    @Test
    public void detectUniqueIndexWithoutOwningConstraint() {
        IndexDescriptor descriptor = IndexRuleTest.uniqueForLabel(10, 30);
        StoreIndexDescriptor indexRule = descriptor.withId(1L);
        Assert.assertTrue((boolean)indexRule.isIndexWithoutOwningConstraint());
    }

    private void assertEqualityByDescriptor(IndexDescriptor descriptor) {
        StoreIndexDescriptor rule1 = descriptor.withId(1L);
        StoreIndexDescriptor rule2 = descriptor.withId(2L);
        StoreIndexDescriptor rule3 = (descriptor.type() == IndexDescriptor.Type.GENERAL ? IndexDescriptorFactory.forSchema((SchemaDescriptor)descriptor.schema()) : IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor.schema())).withId(1L);
        this.assertEquality(rule1, rule2);
        this.assertEquality(rule1, rule3);
    }
}

