/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

abstract class SchemaRuleTestBase {
    protected static final long RULE_ID = 1L;
    protected static final long RULE_ID_2 = 2L;
    protected static final int LABEL_ID = 10;
    protected static final int LABEL_ID_2 = 11;
    protected static final int REL_TYPE_ID = 20;
    protected static final int PROPERTY_ID_1 = 30;
    protected static final int PROPERTY_ID_2 = 31;
    protected static final IndexProviderDescriptor PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("index-provider", "1.0");

    SchemaRuleTestBase() {
    }

    protected void assertEquality(Object o1, Object o2) {
        MatcherAssert.assertThat((Object)o1, (Matcher)Matchers.equalTo((Object)o2));
        MatcherAssert.assertThat((Object)o2, (Matcher)Matchers.equalTo((Object)o1));
        MatcherAssert.assertThat((Object)o1.hashCode(), (Matcher)Matchers.equalTo((Object)o2.hashCode()));
    }

    public static IndexDescriptor forLabel(int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), (IndexProviderDescriptor)PROVIDER_DESCRIPTOR);
    }

    public static IndexDescriptor namedForLabel(String name, int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), Optional.of(name), (IndexProviderDescriptor)PROVIDER_DESCRIPTOR);
    }

    public static IndexDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), Optional.empty(), (IndexProviderDescriptor)PROVIDER_DESCRIPTOR);
    }

    public static IndexDescriptor namedUniqueForLabel(String name, int labelId, int ... propertyIds) {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds), Optional.of(name), (IndexProviderDescriptor)PROVIDER_DESCRIPTOR);
    }
}

