/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.CountsMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreMigratorIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private final Monitors monitors = new Monitors();
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    private JobScheduler jobScheduler;
    @Parameterized.Parameter(value=0)
    public String version;
    @Parameterized.Parameter(value=1)
    public LogPosition expectedLogPosition;
    @Parameterized.Parameter(value=2)
    public Function<TransactionId, Boolean> txIdComparator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> versions() {
        return Arrays.asList(new Object[][]{{StandardV2_3.STORE_VERSION, new LogPosition(3L, 169L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(39L, 1L)}});
    }

    @Before
    public void setUp() throws Exception {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @After
    public void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnMoving() throws Exception {
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, databaseLayout.databaseDirectory(), prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(databaseLayout.databaseDirectory());
        UpgradableDatabase upgradableDatabase = StoreMigratorIT.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradable(databaseLayout).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("upgrade");
        migrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        migrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(databaseLayout, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldBeAbleToMigrateWithoutErrors() throws Exception {
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, databaseLayout.databaseDirectory(), prepare);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(databaseLayout.databaseDirectory());
        UpgradableDatabase upgradableDatabase = StoreMigratorIT.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradable(databaseLayout).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("upgrade");
        migrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(databaseLayout, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
        logProvider.assertNoLogCallContaining("ERROR");
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnRebuildingCounts() throws Exception {
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, databaseLayout.databaseDirectory(), prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(databaseLayout.databaseDirectory());
        UpgradableDatabase upgradableDatabase = StoreMigratorIT.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradable(databaseLayout).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("upgrade");
        migrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        progressMonitor = new SilentMigrationProgressMonitor();
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        countsMigrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationLayout, databaseLayout, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(databaseLayout, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldComputeTheLastTxLogPositionCorrectly() throws Throwable {
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, databaseLayout.databaseDirectory(), prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(databaseLayout.databaseDirectory());
        UpgradableDatabase upgradableDatabase = StoreMigratorIT.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradable(databaseLayout).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("upgrade");
        migrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertEquals((Object)this.expectedLogPosition, (Object)migrator.readLastTxLogPosition(migrationLayout));
    }

    @Test
    public void shouldComputeTheLastTxInfoCorrectly() throws Exception {
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, databaseLayout.databaseDirectory(), prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(databaseLayout.databaseDirectory());
        UpgradableDatabase upgradableDatabase = StoreMigratorIT.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradable(databaseLayout).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService, this.jobScheduler);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("upgrade");
        migrator.migrate(databaseLayout, migrationLayout, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertTrue((boolean)this.txIdComparator.apply(migrator.readLastTxInformation(migrationLayout)));
    }

    private static UpgradableDatabase getUpgradableDatabase(PageCache pageCache, LogTailScanner tailScanner) {
        return new UpgradableDatabase(new StoreVersionCheck(pageCache), StoreMigratorIT.selectFormat(), tailScanner);
    }

    private LogTailScanner getTailScanner(File databaseDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)databaseDirectory, (FileSystemAbstraction)this.fs).build();
        return new LogTailScanner(logFiles, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors);
    }

    private static RecordFormats selectFormat() {
        return Standard.LATEST_RECORD_FORMATS;
    }

    private static Function<TransactionId, Boolean> txInfoAcceptanceOnIdAndTimestamp(long id, long timestamp) {
        return txInfo -> txInfo.transactionId() == id && txInfo.commitTimestamp() == timestamp;
    }
}

