/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;

public class EagerlyReversedTransactionCursorTest {
    @Test
    public void shouldReverseTransactionsFromSource() throws Exception {
        CommittedTransactionRepresentation tx1 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        CommittedTransactionRepresentation tx2 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        CommittedTransactionRepresentation tx3 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        TransactionCursor source = GivenTransactionCursor.given(tx1, tx2, tx3);
        EagerlyReversedTransactionCursor cursor = new EagerlyReversedTransactionCursor(source);
        Object[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        Assert.assertArrayEquals((Object[])Iterators.array((Object[])new CommittedTransactionRepresentation[]{tx3, tx2, tx1}), (Object[])reversed);
    }

    @Test
    public void shouldHandleEmptySource() throws Exception {
        TransactionCursor source = GivenTransactionCursor.given(new CommittedTransactionRepresentation[0]);
        EagerlyReversedTransactionCursor cursor = new EagerlyReversedTransactionCursor(source);
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        Assert.assertEquals((long)0L, (long)reversed.length);
    }
}

