/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import org.junit.Assert;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class ReadAheadChannelTest {
    @Inject
    protected EphemeralFileSystemAbstraction fileSystem;

    ReadAheadChannelTest() {
    }

    @ParameterizedTest
    @EnumSource(value=BufferFactories.class)
    void shouldThrowExceptionForReadAfterEOFIfNotEnoughBytesExist(IntFunction<ByteBuffer> bufferFactory) throws Exception {
        StoreChannel storeChannel = this.fileSystem.open(new File("foo.txt"), OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.force(false);
        storeChannel.close();
        storeChannel = this.fileSystem.open(new File("foo.txt"), OpenMode.READ);
        ReadAheadChannel channel = new ReadAheadChannel(storeChannel, bufferFactory.apply(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE));
        Assert.assertEquals((long)1L, (long)channel.get());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=BufferFactories.class)
    void shouldReturnValueIfSufficientBytesAreBufferedEvenIfEOFHasBeenEncountered(IntFunction<ByteBuffer> bufferFactory) throws Exception {
        StoreChannel storeChannel = this.fileSystem.open(new File("foo.txt"), OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.force(false);
        storeChannel.close();
        storeChannel = this.fileSystem.open(new File("foo.txt"), OpenMode.READ);
        ReadAheadChannel channel = new ReadAheadChannel(storeChannel, bufferFactory.apply(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE));
        try {
            channel.getShort();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)channel.get());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=BufferFactories.class)
    void shouldHandleRunningOutOfBytesWhenRequestSpansMultipleFiles(IntFunction<ByteBuffer> bufferFactory) throws Exception {
        StoreChannel storeChannel1 = this.fileSystem.open(new File("foo.1"), OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.flip();
        storeChannel1.writeAll(buffer);
        storeChannel1.force(false);
        storeChannel1.close();
        buffer.flip();
        StoreChannel storeChannel2 = this.fileSystem.open(new File("foo.2"), OpenMode.READ);
        buffer.put((byte)0);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel2.writeAll(buffer);
        storeChannel2.force(false);
        storeChannel2.close();
        storeChannel1 = this.fileSystem.open(new File("foo.1"), OpenMode.READ);
        final StoreChannel storeChannel2Copy = this.fileSystem.open(new File("foo.2"), OpenMode.READ);
        ReadAheadChannel<StoreChannel> channel = new ReadAheadChannel<StoreChannel>(storeChannel1, bufferFactory.apply(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE)){

            protected StoreChannel next(StoreChannel channel) {
                return storeChannel2Copy;
            }
        };
        try {
            channel.getLong();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)channel.getInt());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=BufferFactories.class)
    void shouldReturnPositionWithinBufferedStream(IntFunction<ByteBuffer> bufferFactory) throws Exception {
        File file = new File("foo.txt");
        int readAheadSize = 512;
        int fileSize = readAheadSize * 8;
        this.createFile(this.fileSystem, file, fileSize);
        ReadAheadChannel bufferedReader = new ReadAheadChannel(this.fileSystem.open(file, OpenMode.READ), bufferFactory.apply(readAheadSize));
        for (int i = 0; i < fileSize / 8; ++i) {
            Assert.assertEquals((long)(8 * i), (long)bufferedReader.position());
            bufferedReader.getLong();
        }
        Assert.assertEquals((long)fileSize, (long)bufferedReader.position());
        try {
            bufferedReader.getLong();
            Assert.fail();
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)fileSize, (long)bufferedReader.position());
    }

    private void createFile(EphemeralFileSystemAbstraction fsa, File name, int bufferSize) throws IOException {
        StoreChannel storeChannel = fsa.open(name, OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (int i = 0; i < bufferSize; ++i) {
            buffer.put((byte)i);
        }
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.close();
    }

    static enum BufferFactories implements IntFunction<ByteBuffer>
    {
        HEAP{

            @Override
            public ByteBuffer apply(int value) {
                return ByteBuffer.allocate(value);
            }
        }
        ,
        DIRECT{

            @Override
            public ByteBuffer apply(int value) {
                return ByteBuffer.allocateDirect(value);
            }
        };

    }
}

