/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityCommandGrouper;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.OnlineIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class OnlineIndexUpdatesTest {
    private static final int ENTITY_TOKEN = 1;
    private static final int OTHER_ENTITY_TOKEN = 2;
    private static final int[] ENTITY_TOKENS = new int[]{1};
    @Rule
    public PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    private NodeStore nodeStore;
    private RelationshipStore relationshipStore;
    private IndexingService indexingService;
    private PropertyPhysicalToLogicalConverter propertyPhysicalToLogicalConverter;
    private NeoStores neoStores;
    private LifeSupport life;
    private PropertyCreator propertyCreator;
    private DirectRecordAccess<PropertyRecord, PrimitiveRecord> recordAccess;

    @Before
    public void setUp() throws Exception {
        this.life = new LifeSupport();
        PageCache pageCache = this.storage.pageCache();
        DatabaseLayout databaseLayout = this.storage.directory().databaseLayout();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)IndexProvider.EMPTY.getProviderDescriptor().name());
        NullLogProvider nullLogProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), pageCache, this.storage.fileSystem(), (LogProvider)nullLogProvider, EmptyVersionContextSupplier.EMPTY);
        this.neoStores = storeFactory.openAllNeoStores(true);
        this.neoStores.getCounts().start();
        CountsComputer.recomputeCounts((NeoStores)this.neoStores, (PageCache)pageCache, (DatabaseLayout)databaseLayout);
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        JobScheduler scheduler = JobSchedulerFactory.createScheduler();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)IndexProvider.EMPTY);
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap((DependencyResolver)dependencies, config);
        this.life.add((Lifecycle)providerMap);
        this.indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)scheduler, (IndexProviderMap)providerMap, (IndexStoreView)new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, this.neoStores), (TokenNameLookup)SchemaUtil.idTokenNameLookup, (Iterable)Iterables.empty(), (LogProvider)nullLogProvider, (LogProvider)nullLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)new DatabaseSchemaState((LogProvider)nullLogProvider));
        this.propertyPhysicalToLogicalConverter = new PropertyPhysicalToLogicalConverter(this.neoStores.getPropertyStore());
        this.life.add((Lifecycle)this.indexingService);
        this.life.add((Lifecycle)scheduler);
        this.life.init();
        this.life.start();
        this.propertyCreator = new PropertyCreator(this.neoStores.getPropertyStore(), new PropertyTraverser());
        this.recordAccess = new DirectRecordAccess((RecordStore)this.neoStores.getPropertyStore(), Loaders.propertyLoader((PropertyStore)propertyStore));
    }

    @After
    public void tearDown() {
        this.life.shutdown();
        this.neoStores.close();
    }

    @Test
    public void shouldContainFedNodeUpdate() throws Exception {
        OnlineIndexUpdates onlineIndexUpdates = new OnlineIndexUpdates(this.nodeStore, this.relationshipStore, (IndexingUpdateService)this.indexingService, this.propertyPhysicalToLogicalConverter);
        int nodeId = 0;
        NodeRecord inUse = this.getNode(nodeId, true);
        Value propertyValue = Values.of((Object)"hej");
        long propertyId = this.createNodeProperty(inUse, propertyValue, 1);
        NodeRecord notInUse = this.getNode(nodeId, false);
        this.nodeStore.updateRecord(inUse);
        Command.NodeCommand nodeCommand = new Command.NodeCommand(inUse, notInUse);
        PropertyRecord propertyBlocks = new PropertyRecord(propertyId);
        propertyBlocks.setNodeId((long)nodeId);
        Command.PropertyCommand propertyCommand = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(propertyId).forReadingData(), propertyBlocks);
        StoreIndexDescriptor indexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.NODE, (int[])new int[]{1, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(0L);
        this.indexingService.createIndexes(new StoreIndexDescriptor[]{indexDescriptor});
        this.indexingService.getIndexProxy(indexDescriptor.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        onlineIndexUpdates.feed(this.nodeGroup(nodeCommand, propertyCommand), this.relationshipGroup(null, new Command.PropertyCommand[0]));
        Assert.assertTrue((boolean)onlineIndexUpdates.hasUpdates());
        Iterator iterator = onlineIndexUpdates.iterator();
        Assert.assertEquals(iterator.next(), (Object)IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{propertyValue, null, null}));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldContainFedRelationshipUpdate() throws Exception {
        OnlineIndexUpdates onlineIndexUpdates = new OnlineIndexUpdates(this.nodeStore, this.relationshipStore, (IndexingUpdateService)this.indexingService, this.propertyPhysicalToLogicalConverter);
        long relId = 0L;
        RelationshipRecord inUse = this.getRelationship(relId, true, 1);
        Value propertyValue = Values.of((Object)"hej");
        long propertyId = this.createRelationshipProperty(inUse, propertyValue, 1);
        RelationshipRecord notInUse = this.getRelationship(relId, false, 1);
        this.relationshipStore.updateRecord((AbstractBaseRecord)inUse);
        Command.RelationshipCommand relationshipCommand = new Command.RelationshipCommand(inUse, notInUse);
        PropertyRecord propertyBlocks = new PropertyRecord(propertyId);
        propertyBlocks.setRelId(relId);
        Command.PropertyCommand propertyCommand = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(propertyId).forReadingData(), propertyBlocks);
        StoreIndexDescriptor indexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(0L);
        this.indexingService.createIndexes(new StoreIndexDescriptor[]{indexDescriptor});
        this.indexingService.getIndexProxy(indexDescriptor.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        onlineIndexUpdates.feed(this.nodeGroup(null, new Command.PropertyCommand[0]), this.relationshipGroup(relationshipCommand, propertyCommand));
        Assert.assertTrue((boolean)onlineIndexUpdates.hasUpdates());
        Iterator iterator = onlineIndexUpdates.iterator();
        Assert.assertEquals(iterator.next(), (Object)IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{propertyValue, null, null}));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldDifferentiateNodesAndRelationships() throws Exception {
        OnlineIndexUpdates onlineIndexUpdates = new OnlineIndexUpdates(this.nodeStore, this.relationshipStore, (IndexingUpdateService)this.indexingService, this.propertyPhysicalToLogicalConverter);
        int nodeId = 0;
        NodeRecord inUseNode = this.getNode(nodeId, true);
        Value nodePropertyValue = Values.of((Object)"hej");
        long nodePropertyId = this.createNodeProperty(inUseNode, nodePropertyValue, 1);
        NodeRecord notInUseNode = this.getNode(nodeId, false);
        this.nodeStore.updateRecord(inUseNode);
        Command.NodeCommand nodeCommand = new Command.NodeCommand(inUseNode, notInUseNode);
        PropertyRecord nodePropertyBlocks = new PropertyRecord(nodePropertyId);
        nodePropertyBlocks.setNodeId((long)nodeId);
        Command.PropertyCommand nodePropertyCommand = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(nodePropertyId).forReadingData(), nodePropertyBlocks);
        StoreIndexDescriptor nodeIndexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.NODE, (int[])new int[]{1, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(0L);
        this.indexingService.createIndexes(new StoreIndexDescriptor[]{nodeIndexDescriptor});
        this.indexingService.getIndexProxy(nodeIndexDescriptor.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        long relId = 0L;
        RelationshipRecord inUse = this.getRelationship(relId, true, 1);
        Value relationshipPropertyValue = Values.of((Object)"da");
        long propertyId = this.createRelationshipProperty(inUse, relationshipPropertyValue, 1);
        RelationshipRecord notInUse = this.getRelationship(relId, false, 1);
        this.relationshipStore.updateRecord((AbstractBaseRecord)inUse);
        Command.RelationshipCommand relationshipCommand = new Command.RelationshipCommand(inUse, notInUse);
        PropertyRecord relationshipPropertyBlocks = new PropertyRecord(propertyId);
        relationshipPropertyBlocks.setRelId(relId);
        Command.PropertyCommand relationshipPropertyCommand = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(propertyId).forReadingData(), relationshipPropertyBlocks);
        StoreIndexDescriptor relationshipIndexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(1L);
        this.indexingService.createIndexes(new StoreIndexDescriptor[]{relationshipIndexDescriptor});
        this.indexingService.getIndexProxy(relationshipIndexDescriptor.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        onlineIndexUpdates.feed(this.nodeGroup(nodeCommand, nodePropertyCommand), this.relationshipGroup(relationshipCommand, relationshipPropertyCommand));
        Assert.assertTrue((boolean)onlineIndexUpdates.hasUpdates());
        Assert.assertThat((Object)onlineIndexUpdates, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)relationshipIndexDescriptor, (Value[])new Value[]{relationshipPropertyValue, null, null}), IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)nodeIndexDescriptor, (Value[])new Value[]{nodePropertyValue, null, null})}));
    }

    @Test
    public void shouldUpdateCorrectIndexes() throws Exception {
        OnlineIndexUpdates onlineIndexUpdates = new OnlineIndexUpdates(this.nodeStore, this.relationshipStore, (IndexingUpdateService)this.indexingService, this.propertyPhysicalToLogicalConverter);
        long relId = 0L;
        RelationshipRecord inUse = this.getRelationship(relId, true, 1);
        Value propertyValue = Values.of((Object)"hej");
        Value propertyValue2 = Values.of((Object)"da");
        long propertyId = this.createRelationshipProperty(inUse, propertyValue, 1);
        long propertyId2 = this.createRelationshipProperty(inUse, propertyValue2, 4);
        RelationshipRecord notInUse = this.getRelationship(relId, false, 1);
        this.relationshipStore.updateRecord((AbstractBaseRecord)inUse);
        Command.RelationshipCommand relationshipCommand = new Command.RelationshipCommand(inUse, notInUse);
        PropertyRecord propertyBlocks = new PropertyRecord(propertyId);
        propertyBlocks.setRelId(relId);
        Command.PropertyCommand propertyCommand = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(propertyId).forReadingData(), propertyBlocks);
        PropertyRecord propertyBlocks2 = new PropertyRecord(propertyId2);
        propertyBlocks2.setRelId(relId);
        Command.PropertyCommand propertyCommand2 = new Command.PropertyCommand((PropertyRecord)this.recordAccess.getIfLoaded(propertyId2).forReadingData(), propertyBlocks2);
        StoreIndexDescriptor indexDescriptor0 = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(0L);
        StoreIndexDescriptor indexDescriptor1 = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])ENTITY_TOKENS, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{2, 4, 6}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(1L);
        StoreIndexDescriptor indexDescriptor2 = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])new int[]{1, 2}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(2L);
        StoreIndexDescriptor indexDescriptor3 = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.multiToken((int[])new int[]{2}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor()).withId(3L);
        this.indexingService.createIndexes(new StoreIndexDescriptor[]{indexDescriptor0, indexDescriptor1, indexDescriptor2});
        this.indexingService.getIndexProxy(indexDescriptor0.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        this.indexingService.getIndexProxy(indexDescriptor1.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        this.indexingService.getIndexProxy(indexDescriptor2.schema()).awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        onlineIndexUpdates.feed(this.nodeGroup(null, new Command.PropertyCommand[0]), this.relationshipGroup(relationshipCommand, propertyCommand, propertyCommand2));
        Assert.assertTrue((boolean)onlineIndexUpdates.hasUpdates());
        Assert.assertThat((Object)onlineIndexUpdates, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor0, (Value[])new Value[]{propertyValue, propertyValue2, null}), IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor1, (Value[])new Value[]{null, propertyValue2, null}), IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor2, (Value[])new Value[]{propertyValue})}));
        Assert.assertThat((Object)onlineIndexUpdates, (Matcher)Matchers.not((Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{indexDescriptor3})));
    }

    private EntityCommandGrouper.Cursor nodeGroup(Command.NodeCommand nodeCommand, Command.PropertyCommand ... propertyCommands) {
        return this.group(nodeCommand, Command.NodeCommand.class, propertyCommands);
    }

    private EntityCommandGrouper.Cursor relationshipGroup(Command.RelationshipCommand relationshipCommand, Command.PropertyCommand ... propertyCommands) {
        return this.group(relationshipCommand, Command.RelationshipCommand.class, propertyCommands);
    }

    private <ENTITY extends Command> EntityCommandGrouper.Cursor group(ENTITY entityCommand, Class<ENTITY> cls, Command.PropertyCommand ... propertyCommands) {
        EntityCommandGrouper grouper = new EntityCommandGrouper(cls, 8);
        if (entityCommand != null) {
            grouper.add(entityCommand);
        }
        for (Command.PropertyCommand propertyCommand : propertyCommands) {
            grouper.add((Command)propertyCommand);
        }
        return grouper.sortAndAccessGroups();
    }

    private long createRelationshipProperty(RelationshipRecord relRecord, Value propertyValue, int propertyKey) {
        return this.propertyCreator.createPropertyChain((PrimitiveRecord)relRecord, Collections.singletonList(this.propertyCreator.encodePropertyValue(propertyKey, propertyValue)).iterator(), this.recordAccess);
    }

    private long createNodeProperty(NodeRecord inUse, Value value, int propertyKey) {
        return this.propertyCreator.createPropertyChain((PrimitiveRecord)inUse, Collections.singletonList(this.propertyCreator.encodePropertyValue(propertyKey, value)).iterator(), this.recordAccess);
    }

    private NodeRecord getNode(int nodeId, boolean inUse) {
        NodeRecord nodeRecord = new NodeRecord((long)nodeId);
        nodeRecord = nodeRecord.initialize(inUse, Record.NO_NEXT_PROPERTY.longValue(), false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue());
        if (inUse) {
            InlineNodeLabels labelFieldWriter = new InlineNodeLabels(nodeRecord);
            labelFieldWriter.put(new long[]{1L}, null, null);
        }
        return nodeRecord;
    }

    private RelationshipRecord getRelationship(long relId, boolean inUse, int type) {
        if (!inUse) {
            type = -1;
        }
        return new RelationshipRecord(relId).initialize(inUse, Record.NO_NEXT_PROPERTY.longValue(), 0L, 0L, type, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_NEXT_RELATIONSHIP.longValue(), true, false);
    }
}

