/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardFormatFamily;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class PrepareTrackingRecordFormats
implements RecordFormats {
    private final RecordFormats actual;
    private final Set<NodeRecord> nodePrepare = new HashSet<NodeRecord>();
    private final Set<RelationshipRecord> relationshipPrepare = new HashSet<RelationshipRecord>();
    private final Set<RelationshipGroupRecord> relationshipGroupPrepare = new HashSet<RelationshipGroupRecord>();
    private final Set<PropertyRecord> propertyPrepare = new HashSet<PropertyRecord>();
    private final Set<DynamicRecord> dynamicPrepare = new HashSet<DynamicRecord>();
    private final Set<PropertyKeyTokenRecord> propertyKeyTokenPrepare = new HashSet<PropertyKeyTokenRecord>();
    private final Set<LabelTokenRecord> labelTokenPrepare = new HashSet<LabelTokenRecord>();
    private final Set<RelationshipTypeTokenRecord> relationshipTypeTokenPrepare = new HashSet<RelationshipTypeTokenRecord>();
    private final Set<MetaDataRecord> metaDataPrepare = new HashSet<MetaDataRecord>();

    public PrepareTrackingRecordFormats(RecordFormats actual) {
        this.actual = actual;
    }

    public String storeVersion() {
        return this.actual.storeVersion();
    }

    public String introductionVersion() {
        return this.actual.introductionVersion();
    }

    public PrepareTrackingRecordFormat<NodeRecord> node() {
        return new PrepareTrackingRecordFormat<NodeRecord>(this.actual.node(), this.nodePrepare);
    }

    public PrepareTrackingRecordFormat<RelationshipGroupRecord> relationshipGroup() {
        return new PrepareTrackingRecordFormat<RelationshipGroupRecord>(this.actual.relationshipGroup(), this.relationshipGroupPrepare);
    }

    public PrepareTrackingRecordFormat<RelationshipRecord> relationship() {
        return new PrepareTrackingRecordFormat<RelationshipRecord>(this.actual.relationship(), this.relationshipPrepare);
    }

    public PrepareTrackingRecordFormat<PropertyRecord> property() {
        return new PrepareTrackingRecordFormat<PropertyRecord>(this.actual.property(), this.propertyPrepare);
    }

    public PrepareTrackingRecordFormat<LabelTokenRecord> labelToken() {
        return new PrepareTrackingRecordFormat<LabelTokenRecord>(this.actual.labelToken(), this.labelTokenPrepare);
    }

    public PrepareTrackingRecordFormat<PropertyKeyTokenRecord> propertyKeyToken() {
        return new PrepareTrackingRecordFormat<PropertyKeyTokenRecord>(this.actual.propertyKeyToken(), this.propertyKeyTokenPrepare);
    }

    public PrepareTrackingRecordFormat<RelationshipTypeTokenRecord> relationshipTypeToken() {
        return new PrepareTrackingRecordFormat<RelationshipTypeTokenRecord>(this.actual.relationshipTypeToken(), this.relationshipTypeTokenPrepare);
    }

    public PrepareTrackingRecordFormat<DynamicRecord> dynamic() {
        return new PrepareTrackingRecordFormat<DynamicRecord>(this.actual.dynamic(), this.dynamicPrepare);
    }

    public PrepareTrackingRecordFormat<MetaDataRecord> metaData() {
        return new PrepareTrackingRecordFormat<MetaDataRecord>(this.actual.metaData(), this.metaDataPrepare);
    }

    public Capability[] capabilities() {
        return this.actual.capabilities();
    }

    public int generation() {
        return this.actual.generation();
    }

    public boolean hasCapability(Capability capability) {
        return this.actual.hasCapability(capability);
    }

    public FormatFamily getFormatFamily() {
        return StandardFormatFamily.INSTANCE;
    }

    public boolean hasCompatibleCapabilities(RecordFormats other, CapabilityType type) {
        return this.actual.hasCompatibleCapabilities(other, type);
    }

    public String name() {
        return this.getClass().getName();
    }

    public class PrepareTrackingRecordFormat<RECORD extends AbstractBaseRecord>
    implements RecordFormat<RECORD> {
        private final RecordFormat<RECORD> actual;
        private final Set<RECORD> prepare;

        PrepareTrackingRecordFormat(RecordFormat<RECORD> actual, Set<RECORD> prepare) {
            this.actual = actual;
            this.prepare = prepare;
        }

        public RECORD newRecord() {
            return (RECORD)this.actual.newRecord();
        }

        public int getRecordSize(StoreHeader storeHeader) {
            return this.actual.getRecordSize(storeHeader);
        }

        public int getRecordHeaderSize() {
            return this.actual.getRecordHeaderSize();
        }

        public boolean isInUse(PageCursor cursor) {
            return this.actual.isInUse(cursor);
        }

        public void read(RECORD record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
            this.actual.read(record, cursor, mode, recordSize);
        }

        public void prepare(RECORD record, int recordSize, IdSequence idSequence) {
            this.prepare.add(record);
            this.actual.prepare(record, recordSize, idSequence);
        }

        public void write(RECORD record, PageCursor cursor, int recordSize) throws IOException {
            this.actual.write(record, cursor, recordSize);
        }

        public long getNextRecordReference(RECORD record) {
            return this.actual.getNextRecordReference(record);
        }

        public long getMaxId() {
            return this.actual.getMaxId();
        }

        public boolean equals(Object otherFormat) {
            return this.actual.equals(otherFormat);
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean prepared(RECORD record) {
            return this.prepare.contains(record);
        }
    }
}

