/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LabelScanViewNodeStoreScanTest {
    private NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
    private IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);

    @Before
    public void setUp() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
        Mockito.when((Object)this.neoStores.getNodeStore()).thenReturn((Object)this.nodeStore);
    }

    @Test
    public void iterateOverLabeledNodeIds() {
        PrimitiveLongResourceIterator labeledNodes = PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L, 2L, 4L, 8L});
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)15L);
        int[] labelIds = new int[]{1, 2};
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(labelIds)).thenReturn((Object)labeledNodes);
        LabelScanViewNodeStoreScan<Exception> storeScan = this.getLabelScanViewStoreScan(labelIds);
        EntityIdIterator idIterator = storeScan.getEntityIdIterator();
        List visitedNodeIds = PrimitiveLongCollections.asList((LongIterator)idIterator);
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasItems((Object[])new Long[]{1L, 2L, 4L, 8L}));
    }

    private LabelScanViewNodeStoreScan<Exception> getLabelScanViewStoreScan(int[] labelIds) {
        return new LabelScanViewNodeStoreScan((StorageReader)new RecordStorageReader(this.neoStores), LockService.NO_LOCK_SERVICE, this.labelScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, labelIds, this.propertyKeyIdFilter);
    }
}

