/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.test.rule.TestDirectory;

public class ConvertersTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldSortFilesByNumberCleverly() throws Exception {
        File file1 = this.existenceOfFile("file1");
        File file123 = this.existenceOfFile("file123");
        File file12 = this.existenceOfFile("file12");
        File file2 = this.existenceOfFile("file2");
        File file32 = this.existenceOfFile("file32");
        Object[] files = (File[])Converters.regexFiles((boolean)true).apply(this.directory.file("file.*").getAbsolutePath());
        Assert.assertArrayEquals((Object[])new File[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    @Test
    public void canProcessPortFromAGivenString() {
        String addressWithPorts = "hostname:1234";
        Optional port = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithPorts).getPort();
        Assert.assertTrue((boolean)port.isPresent());
        Assert.assertEquals((Object)1234, port.get());
    }

    @Test
    public void emptyOptionalWhenPortIsMissing() {
        String addressWithoutPorts = "hostname";
        Optional port = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithoutPorts).getPort();
        Assert.assertFalse((boolean)port.isPresent());
    }

    @Test
    public void canProcessHostnameFromAGivenAddress() {
        String addressWithPorts = "hostname:1234";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithPorts).getHostname();
        Assert.assertTrue((boolean)hostname.isPresent());
        Assert.assertEquals((Object)"hostname", hostname.get());
    }

    @Test
    public void canProcessHostnameWithoutPort() {
        String addressWithoutPort = "hostname";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithoutPort).getHostname();
        Assert.assertTrue((boolean)hostname.isPresent());
        Assert.assertEquals((Object)"hostname", hostname.get());
    }

    @Test
    public void emptyOptionalWhenOnlyPort() {
        String portOnlyAddress = ":1234";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)portOnlyAddress).getHostname();
        Assert.assertFalse((boolean)hostname.isPresent());
    }

    @Test
    public void ipv6Works() {
        String full = "1234:5678:9abc:def0:1234:5678:9abc:def0";
        List<Pair> cases = Arrays.asList(Pair.of((Object)"[::1]", (Object)new OptionalHostnamePort("::1", null, null)), Pair.of((Object)"[3FFe::1]", (Object)new OptionalHostnamePort("3FFe::1", null, null)), Pair.of((Object)"[::1]:2", (Object)new OptionalHostnamePort("::1", Integer.valueOf(2), Integer.valueOf(2))), Pair.of((Object)("[" + full + "]"), (Object)new OptionalHostnamePort(full, null, null)), Pair.of((Object)("[" + full + "]:5432"), (Object)new OptionalHostnamePort(full, Integer.valueOf(5432), Integer.valueOf(5432))), Pair.of((Object)"[1::2]:3-4", (Object)new OptionalHostnamePort("1::2", Integer.valueOf(3), Integer.valueOf(4))));
        for (Pair useCase : cases) {
            String caseInput = (String)useCase.first();
            OptionalHostnamePort caseOutput = (OptionalHostnamePort)useCase.other();
            OptionalHostnamePort optionalHostnamePort = Converters.toOptionalHostnamePortFromRawAddress((String)caseInput);
            String msg = String.format("\"%s\" -> %s", caseInput, caseOutput);
            Assert.assertEquals((String)msg, (Object)caseOutput.getHostname(), (Object)optionalHostnamePort.getHostname());
            Assert.assertEquals((String)msg, (Object)caseOutput.getPort(), (Object)optionalHostnamePort.getPort());
            Assert.assertEquals((String)msg, (Object)caseOutput.getUpperRangePort(), (Object)optionalHostnamePort.getUpperRangePort());
        }
    }

    @Test
    public void trailingColonIgnored() {
        OptionalHostnamePort optionalHostnamePort = Converters.toOptionalHostnamePortFromRawAddress((String)"localhost::");
        Assert.assertEquals((Object)"localhost", optionalHostnamePort.getHostname().get());
        Assert.assertFalse((boolean)optionalHostnamePort.getPort().isPresent());
        Assert.assertFalse((boolean)optionalHostnamePort.getUpperRangePort().isPresent());
    }

    private File existenceOfFile(String name) throws IOException {
        File file = this.directory.file(name);
        file.createNewFile();
        return file;
    }
}

