/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class KernelDataTest {
    private final Collection<Kernel> kernels = new HashSet<Kernel>();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);

    @After
    public void tearDown() {
        Iterator<Kernel> kernelIterator = this.kernels.iterator();
        while (kernelIterator.hasNext()) {
            Kernel kernel = kernelIterator.next();
            kernelIterator.remove();
            kernel.shutdown();
        }
    }

    @Test
    public void shouldGenerateUniqueInstanceIdentifiers() {
        Kernel kernel1 = new Kernel(null);
        Kernel kernel2 = new Kernel(null);
        Assert.assertNotNull((Object)kernel1.instanceId());
        Assert.assertNotNull((Object)kernel2.instanceId());
        Assert.assertNotEquals((Object)kernel1.instanceId(), (Object)kernel2.instanceId());
    }

    @Test
    public void shouldReuseInstanceIdentifiers() {
        Kernel kernel = new Kernel(null);
        String instanceId = kernel.instanceId();
        kernel.shutdown();
        kernel = new Kernel(null);
        Assert.assertEquals((Object)instanceId, (Object)kernel.instanceId());
    }

    @Test
    public void shouldAllowConfigurationOfInstanceId() {
        Kernel kernel = new Kernel("myInstance");
        Assert.assertEquals((Object)"myInstance", (Object)kernel.instanceId());
    }

    @Test
    public void shouldGenerateInstanceIdentifierWhenNullConfigured() {
        Kernel kernel = new Kernel(null);
        Assert.assertEquals((Object)kernel.instanceId(), (Object)kernel.instanceId().trim());
        Assert.assertTrue((kernel.instanceId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGenerateInstanceIdentifierWhenEmptyStringConfigured() {
        Kernel kernel = new Kernel("");
        Assert.assertEquals((Object)kernel.instanceId(), (Object)kernel.instanceId().trim());
        Assert.assertTrue((kernel.instanceId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotAllowMultipleInstancesWithTheSameConfiguredInstanceId() {
        new Kernel("myInstance");
        try {
            new Kernel("myInstance");
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"There is already a kernel started with unsupported.dbms.kernel_id='myInstance'.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowReuseOfConfiguredInstanceIdAfterShutdown() {
        new Kernel("myInstance").shutdown();
        Kernel kernel = new Kernel("myInstance");
        Assert.assertEquals((Object)"myInstance", (Object)kernel.instanceId());
    }

    private class Kernel
    extends KernelData {
        Kernel(String desiredId) {
            super(KernelDataTest.this.fileSystemRule.get(), KernelDataTest.this.pageCacheRule.getPageCache(KernelDataTest.this.fileSystemRule.get()), new File("graph.db"), Config.defaults((Setting)GraphDatabaseSettings.forced_kernel_id, (String)desiredId), (DataSourceManager)Mockito.mock(DataSourceManager.class));
            KernelDataTest.this.kernels.add(this);
        }

        public void shutdown() {
            super.shutdown();
            KernelDataTest.this.kernels.remove((Object)this);
        }
    }
}

