/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class LogTailScannerTest {
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.testDirectory).around((TestRule)this.pageCacheRule);
    private final LogEntryReader<ReadableClosablePositionAwareChannel> reader = new VersionAwareLogEntryReader();
    private LogTailScanner tailScanner;
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private final int startLogVersion;
    private final int endLogVersion;
    private final LogEntryVersion latestLogEntryVersion = LogEntryVersion.CURRENT;
    private LogVersionRepository logVersionRepository;

    public LogTailScannerTest(Integer startLogVersion, Integer endLogVersion) {
        this.startLogVersion = startLogVersion;
        this.endLogVersion = endLogVersion;
    }

    @Parameterized.Parameters(name="{0},{1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({1, 2}, {42, 43});
    }

    @Before
    public void setUp() throws IOException {
        this.logVersionRepository = new SimpleLogVersionRepository();
        this.logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.testDirectory.databaseLayout(), (FileSystemAbstraction)this.fsRule, (PageCache)this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule)).withLogVersionRepository(this.logVersionRepository).build();
        this.tailScanner = new LogTailScanner(this.logFiles, this.reader, this.monitors);
    }

    @Test
    public void noLogFilesFound() {
        this.setupLogFiles(new LogCreator[0]);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, false, LogTailScanner.NO_TRANSACTION_ID, -1L, logTailInformation);
    }

    @Test
    public void oneLogFileNoCheckPoints() {
        this.setupLogFiles(this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void oneLogFileNoCheckPointsOneStart() {
        long txId = 10L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPoints() {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, LogTailScanner.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStart() {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStartWithoutCommit() {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, LogTailScanner.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsTwoCommits() {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId), LogTailScannerTest.start(), LogTailScannerTest.commit(txId + 1L)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesCheckPointTargetsPrevious() {
        long txId = 6L;
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId - 1L), position), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesStartAndCommitInDifferentFiles() {
        long txId = 6L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.start()), this.logFile(LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, 6L, this.startLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointOnly() {
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartBefore() {
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void bigFileLatestCheckpointFindsStartAfter() throws Throwable {
        long firstTxAfterCheckpoint = 0x80000003L;
        FirstTxIdConfigurableTailScanner tailScanner = new FirstTxIdConfigurableTailScanner(firstTxAfterCheckpoint, this.logFiles, this.reader, this.monitors);
        LogEntryStart startEntry = new LogEntryStart(1, 2, 3L, 4L, new byte[]{5, 6}, new LogPosition((long)this.endLogVersion, 0x80000010L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 16L));
        LogTailScanner.LogTailInformation logTailInformation = tailScanner.checkpointTailInformation(this.endLogVersion, startEntry, this.endLogVersion, this.latestLogEntryVersion, checkPoint, false);
        this.assertLatestCheckPoint(true, true, firstTxAfterCheckpoint, this.endLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesSecondIsCorruptedBeforeCommit() throws IOException {
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(2L)));
        File highestLogFile = this.logFiles.getHighestLogFile();
        this.fsRule.truncate(highestLogFile, this.fsRule.getFileSize(highestLogFile) - 3L);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, LogTailScanner.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesSecondIsCorruptedBeforeAfterCommit() throws IOException {
        int firstTxId = 2;
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(firstTxId), LogTailScannerTest.start(), LogTailScannerTest.commit(3L)));
        File highestLogFile = this.logFiles.getHighestLogFile();
        this.fsRule.truncate(highestLogFile, this.fsRule.getFileSize(highestLogFile) - 3L);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, firstTxId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAfter() {
        long txId = 35L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.commit(txId), LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartWithoutCommitAfter() {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartInBetween() {
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth() {
        long txId = 11L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileContainingAStart() {
        long txId = 11L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()), this.logFile(start, LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileIsEmpty() {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.checkPoint()), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, LogTailScanner.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart() {
        long txId = 123L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStartWithoutCommit() {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart() {
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(3L), position), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog() {
        long txId = 432L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, logTailInformation);
    }

    private void setupLogFiles(LogCreator ... logFiles) {
        HashMap<Entry, LogPosition> positions = new HashMap<Entry, LogPosition>();
        long version = this.endLogVersion - logFiles.length;
        for (LogCreator logFile : logFiles) {
            logFile.create(++version, positions);
        }
    }

    private LogCreator logFile(Entry ... entries) {
        return (logVersion, positions) -> {
            try {
                AtomicLong lastTxId = new AtomicLong();
                this.logVersionRepository.setCurrentLogVersion(logVersion);
                LifeSupport logFileLife = new LifeSupport();
                logFileLife.start();
                logFileLife.add((Lifecycle)this.logFiles);
                LogFile logFile = this.logFiles.getLogFile();
                try {
                    FlushablePositionAwareChannel writeChannel = logFile.getWriter();
                    LogPositionMarker positionMarker = new LogPositionMarker();
                    LogEntryWriter writer = new LogEntryWriter((WritableChannel)writeChannel);
                    for (Entry entry : entries) {
                        LogPosition currentPosition = writeChannel.getCurrentPosition(positionMarker).newPosition();
                        positions.put(entry, currentPosition);
                        if (entry instanceof StartEntry) {
                            writer.writeStartEntry(0, 0, 0L, 0L, new byte[0]);
                            continue;
                        }
                        if (entry instanceof CommitEntry) {
                            CommitEntry commitEntry = (CommitEntry)entry;
                            writer.writeCommitEntry(commitEntry.txId, 0L);
                            lastTxId.set(commitEntry.txId);
                            continue;
                        }
                        if (entry instanceof CheckPointEntry) {
                            LogPosition logPosition;
                            CheckPointEntry checkPointEntry = (CheckPointEntry)entry;
                            Entry target = checkPointEntry.withPositionOfEntry;
                            LogPosition logPosition2 = logPosition = target != null ? (LogPosition)positions.get(target) : currentPosition;
                            assert (logPosition != null) : "No registered log position for " + target;
                            writer.writeCheckPointEntry(logPosition);
                            continue;
                        }
                        if (entry instanceof PositionEntry) continue;
                        throw new IllegalArgumentException("Unknown entry " + entry);
                    }
                }
                finally {
                    logFileLife.shutdown();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static StartEntry start() {
        return new StartEntry();
    }

    private static CommitEntry commit(long txId) {
        return new CommitEntry(txId);
    }

    private static CheckPointEntry checkPoint() {
        return LogTailScannerTest.checkPoint(null);
    }

    private static CheckPointEntry checkPoint(Entry forEntry) {
        return new CheckPointEntry(forEntry);
    }

    private static PositionEntry position() {
        return new PositionEntry();
    }

    private void assertLatestCheckPoint(boolean hasCheckPointEntry, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, long logVersion, LogTailScanner.LogTailInformation logTailInformation) {
        Assert.assertEquals((Object)hasCheckPointEntry, (Object)(logTailInformation.lastCheckPoint != null ? 1 : 0));
        Assert.assertEquals((Object)commitsAfterLastCheckPoint, (Object)logTailInformation.commitsAfterLastCheckpoint());
        if (commitsAfterLastCheckPoint) {
            Assert.assertEquals((long)firstTxIdAfterLastCheckPoint, (long)logTailInformation.firstTxIdAfterLastCheckPoint);
        }
        Assert.assertEquals((long)logVersion, (long)logTailInformation.oldestLogVersionFound);
    }

    private static class FirstTxIdConfigurableTailScanner
    extends LogTailScanner {
        private final long txId;

        FirstTxIdConfigurableTailScanner(long txId, LogFiles logFiles, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, Monitors monitors) {
            super(logFiles, logEntryReader, monitors);
            this.txId = txId;
        }

        protected LogTailScanner.ExtractedTransactionRecord extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) {
            return new LogTailScanner.ExtractedTransactionRecord(this.txId);
        }
    }

    private static class PositionEntry
    implements Entry {
        private PositionEntry() {
        }
    }

    private static class CheckPointEntry
    implements Entry {
        final Entry withPositionOfEntry;

        CheckPointEntry(Entry withPositionOfEntry) {
            this.withPositionOfEntry = withPositionOfEntry;
        }
    }

    private static class CommitEntry
    implements Entry {
        final long txId;

        CommitEntry(long txId) {
            this.txId = txId;
        }
    }

    private static class StartEntry
    implements Entry {
        private StartEntry() {
        }
    }

    static interface Entry {
    }

    static interface LogCreator {
        public void create(long var1, Map<Entry, LogPosition> var3);
    }
}

