/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class TestEphemeralFileChannel {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;

    TestEphemeralFileChannel() {
    }

    @Test
    void smoke() throws Exception {
        StoreChannel channel = this.fileSystem.open(new File("yo"), OpenMode.READ_WRITE);
        ByteBuffer buffer = ByteBuffer.allocate(23);
        buffer.put(new byte[23]);
        buffer.flip();
        channel.write(buffer);
        channel = this.fileSystem.open(new File("yo"), OpenMode.READ_WRITE);
        long longValue = 1234567890L;
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)1);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)2);
        buffer.flip();
        channel.position(6L);
        channel.write(buffer);
        buffer.clear();
        buffer.limit(8);
        buffer.putLong(longValue);
        buffer.flip();
        channel.position(15L);
        channel.write(buffer);
        Assert.assertEquals((long)23L, (long)channel.size());
        buffer.clear();
        buffer.limit(1);
        channel.read(buffer, 0L);
        buffer.flip();
        Assert.assertEquals((long)1L, (long)buffer.get());
        buffer.clear();
        buffer.limit(3);
        channel.read(buffer, 5L);
        buffer.flip();
        Assert.assertEquals((long)0L, (long)buffer.get());
        Assert.assertEquals((long)2L, (long)buffer.get());
        Assert.assertEquals((long)0L, (long)buffer.get());
        buffer.clear();
        buffer.limit(8);
        channel.read(buffer, 15L);
        buffer.flip();
        Assert.assertEquals((long)longValue, (long)buffer.getLong());
    }

    @Test
    void absoluteVersusRelative() throws Exception {
        File file = new File("myfile");
        StoreChannel channel = this.fileSystem.open(file, OpenMode.READ_WRITE);
        byte[] bytes = "test".getBytes();
        channel.write(ByteBuffer.wrap(bytes));
        channel.close();
        channel = this.fileSystem.open(new File(file.getAbsolutePath()), OpenMode.READ);
        byte[] readBytes = new byte[bytes.length];
        channel.readAll(ByteBuffer.wrap(readBytes));
        Assert.assertTrue((boolean)Arrays.equals(bytes, readBytes));
    }

    @Test
    void listFiles() throws Exception {
        File root = new File("/root").getCanonicalFile();
        File dir1 = new File(root, "dir1");
        File dir2 = new File(root, "dir2");
        File subdir1 = new File(dir1, "sub");
        File file1 = new File(dir1, "file");
        File file2 = new File(dir1, "file2");
        File file3 = new File(dir2, "file");
        File file4 = new File(subdir1, "file");
        this.fileSystem.mkdirs(dir2);
        this.fileSystem.mkdirs(dir1);
        this.fileSystem.mkdirs(subdir1);
        this.fileSystem.create(file1);
        this.fileSystem.create(file2);
        this.fileSystem.create(file3);
        this.fileSystem.create(file4);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{dir1, dir2}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(root)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{subdir1, file1, file2}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(dir1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{file3}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(dir2)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{file4}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(subdir1)));
    }
}

