/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.resources.HeapAllocation;

public class FakeHeapAllocation
extends HeapAllocation
implements TestRule {
    private final MutableLongLongMap allocation = new LongLongHashMap();

    public long allocatedBytes(long threadId) {
        return Math.max(0L, this.allocation.get(threadId));
    }

    public FakeHeapAllocation add(long bytes) {
        return this.add(Thread.currentThread().getId(), bytes);
    }

    public FakeHeapAllocation add(long threadId, long bytes) {
        this.allocation.put(threadId, this.allocatedBytes(threadId) + bytes);
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }
}

