/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.function.Function;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.command.IndexActivator;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.MockedNeoStores;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.test.rule.ExternalResource;

public class RecordStorageEngineRule
extends ExternalResource {
    private final LifeSupport life = new LifeSupport();

    protected void before() throws Throwable {
        super.before();
        this.life.start();
    }

    public Builder getWith(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout) {
        return new Builder(fs, pageCache, databaseLayout);
    }

    private RecordStorageEngine get(FileSystemAbstraction fs, PageCache pageCache, IndexProvider indexProvider, DatabaseHealth databaseHealth, DatabaseLayout databaseLayout, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer, Monitors monitors, LockService lockService) {
        EphemeralIdGenerator.Factory idGeneratorFactory = new EphemeralIdGenerator.Factory();
        ExplicitIndexProvider explicitIndexProviderLookup = (ExplicitIndexProvider)Mockito.mock(ExplicitIndexProvider.class);
        Mockito.when((Object)explicitIndexProviderLookup.allIndexProviders()).thenReturn((Object)Iterables.empty());
        IndexConfigStore indexConfigStore = new IndexConfigStore(databaseLayout, fs);
        JobScheduler scheduler = (JobScheduler)this.life.add((Lifecycle)JobSchedulerFactory.createScheduler());
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)indexProvider.getProviderDescriptor().name());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)indexProvider);
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)idGeneratorFactory, IdReuseEligibility.ALWAYS, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
        DefaultIndexProviderMap indexProviderMap = new DefaultIndexProviderMap((DependencyResolver)dependencies, config);
        NullLogProvider nullLogProvider = NullLogProvider.getInstance();
        this.life.add((Lifecycle)indexProviderMap);
        return (RecordStorageEngine)this.life.add((Lifecycle)new ExtendedRecordStorageEngine(databaseLayout, config, pageCache, fs, (LogProvider)nullLogProvider, (LogProvider)nullLogProvider, MockedNeoStores.mockedTokenHolders(), (SchemaState)Mockito.mock(SchemaState.class), (ConstraintSemantics)new StandardConstraintSemantics(), scheduler, (TokenNameLookup)Mockito.mock(TokenNameLookup.class), lockService, (IndexProviderMap)indexProviderMap, IndexingService.NO_MONITOR, databaseHealth, explicitIndexProviderLookup, indexConfigStore, (IdOrderingQueue)new SynchronizedArrayIdOrderingQueue(), idGeneratorFactory, (IdController)new BufferedIdController(bufferingIdGeneratorFactory, scheduler), transactionApplierTransformer, monitors, RecoveryCleanupWorkCollector.immediate(), OperationalMode.single));
    }

    protected void after(boolean successful) throws Throwable {
        this.life.shutdown();
        super.after(successful);
    }

    private static class ExtendedRecordStorageEngine
    extends RecordStorageEngine {
        private final Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer;

        ExtendedRecordStorageEngine(DatabaseLayout databaseLayout, Config config, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, LogProvider userLogProvider, TokenHolders tokenHolders, SchemaState schemaState, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, IndexProviderMap indexProviderMap, IndexingService.Monitor indexingServiceMonitor, DatabaseHealth databaseHealth, ExplicitIndexProvider explicitIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue explicitIndexTransactionOrdering, IdGeneratorFactory idGeneratorFactory, IdController idController, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, OperationalMode operationalMode) {
            super(databaseLayout, config, pageCache, fs, logProvider, userLogProvider, tokenHolders, schemaState, constraintSemantics, scheduler, tokenNameLookup, lockService, indexProviderMap, indexingServiceMonitor, databaseHealth, explicitIndexProviderLookup, indexConfigStore, explicitIndexTransactionOrdering, idGeneratorFactory, idController, monitors, recoveryCleanupWorkCollector, operationalMode, EmptyVersionContextSupplier.EMPTY);
            this.transactionApplierTransformer = transactionApplierTransformer;
        }

        protected BatchTransactionApplierFacade applier(TransactionApplicationMode mode, IndexActivator indexActivator) {
            BatchTransactionApplierFacade recordEngineApplier = super.applier(mode, indexActivator);
            return this.transactionApplierTransformer.apply(recordEngineApplier);
        }
    }

    public class Builder {
        private final FileSystemAbstraction fs;
        private final PageCache pageCache;
        private DatabaseHealth databaseHealth = new DatabaseHealth(new DatabasePanicEventGenerator(new KernelEventHandlers((Log)NullLog.getInstance())), (Log)NullLog.getInstance());
        private final DatabaseLayout databaseLayout;
        private Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer = applierFacade -> applierFacade;
        private IndexProvider indexProvider = IndexProvider.EMPTY;
        private Monitors monitors = new Monitors();
        private LockService lockService = new ReentrantLockService();

        public Builder(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout) {
            this.fs = fs;
            this.pageCache = pageCache;
            this.databaseLayout = databaseLayout;
        }

        public Builder transactionApplierTransformer(Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer) {
            this.transactionApplierTransformer = transactionApplierTransformer;
            return this;
        }

        public Builder indexProvider(IndexProvider indexProvider) {
            this.indexProvider = indexProvider;
            return this;
        }

        public Builder databaseHealth(DatabaseHealth databaseHealth) {
            this.databaseHealth = databaseHealth;
            return this;
        }

        public Builder monitors(Monitors monitors) {
            this.monitors = monitors;
            return this;
        }

        public Builder lockService(LockService lockService) {
            this.lockService = lockService;
            return this;
        }

        public RecordStorageEngine build() {
            return RecordStorageEngineRule.this.get(this.fs, this.pageCache, this.indexProvider, this.databaseHealth, this.databaseLayout, this.transactionApplierTransformer, this.monitors, this.lockService);
        }
    }
}

