/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ProcessRelationshipCountsDataStep;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.SimpleStageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ProcessRelationshipCountsDataStepTest {
    @Test
    public void shouldLetProcessorsBeZeroIfEnoughMemory() {
        ProcessRelationshipCountsDataStep step = this.instantiateStep(10, 10, 10000L, 4, ByteUnit.mebiBytes((long)10L));
        Assert.assertEquals((long)0L, (long)step.getMaxProcessors());
    }

    @Test
    public void shouldNotOverflowWhenTooMuchMemoryAvailable() {
        ProcessRelationshipCountsDataStep step = this.instantiateStep(1, 1, 10000L, 64, ByteUnit.tebiBytes((long)10L));
        Assert.assertEquals((long)0L, (long)step.getMaxProcessors());
    }

    @Test
    public void shouldLimitProcessorsIfScarceMemory() {
        ProcessRelationshipCountsDataStep step = this.instantiateStep(100, 220, ByteUnit.mebiBytes((long)1L), 4, ByteUnit.mebiBytes((long)2L));
        Assert.assertEquals((long)2L, (long)step.getMaxProcessors());
    }

    @Test
    public void shouldAtLeastHaveOneProcessorEvenIfLowMemory() {
        ProcessRelationshipCountsDataStep step = this.instantiateStep(1000, 1000, ByteUnit.mebiBytes((long)1L), 4, ByteUnit.mebiBytes((long)2L));
        Assert.assertEquals((long)1L, (long)step.getMaxProcessors());
    }

    private ProcessRelationshipCountsDataStep instantiateStep(int highLabelId, int highRelationshipTypeId, long labelCacheSize, int maxProcessors, long maxMemory) {
        SimpleStageControl control = new SimpleStageControl();
        NodeLabelsCache cache = this.nodeLabelsCache(labelCacheSize);
        Configuration config = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)config.maxNumberOfProcessors()).thenReturn((Object)maxProcessors);
        Mockito.when((Object)config.maxMemoryUsage()).thenReturn((Object)maxMemory);
        return new ProcessRelationshipCountsDataStep((StageControl)control, cache, config, highLabelId, highRelationshipTypeId, (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class), NumberArrayFactory.OFF_HEAP, (ProgressReporter)SilentProgressReporter.INSTANCE);
    }

    private NodeLabelsCache nodeLabelsCache(long sizeInBytes) {
        NodeLabelsCache cache = (NodeLabelsCache)Mockito.mock(NodeLabelsCache.class);
        ((NodeLabelsCache)Mockito.doAnswer(invocation -> {
            MemoryStatsVisitor visitor = (MemoryStatsVisitor)invocation.getArgument(0);
            visitor.offHeapUsage(sizeInBytes);
            return null;
        }).when((Object)cache)).acceptMemoryStatsVisitor((MemoryStatsVisitor)ArgumentMatchers.any());
        return cache;
    }
}

