/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.test.Race;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeLabelsCacheTest {
    private static final int CHUNK_SIZE = 100;
    private final Random random = new Random(1234L);

    @Test
    public void shouldCacheSmallSetOfLabelsPerNode() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, 5, 100);
        NodeLabelsCache.Client client = cache.newClient();
        long nodeId = 0L;
        cache.put(nodeId, new long[]{1L, 2L, 3L});
        int[] readLabels = new int[3];
        cache.get(client, nodeId, readLabels);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])readLabels);
    }

    @Test
    public void shouldHandleLargeAmountOfLabelsPerNode() {
        int highLabelId = 1000;
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, highLabelId, 100);
        NodeLabelsCache.Client client = cache.newClient();
        long nodeId = 0L;
        int[] labels = this.randomLabels(200, 1000);
        cache.put(nodeId, this.asLongArray(labels));
        int[] readLabels = new int[labels.length];
        cache.get(client, nodeId, readLabels);
        Assert.assertArrayEquals((int[])labels, (int[])readLabels);
    }

    @Test
    public void shouldHandleLabelsForManyNodes() {
        int highLabelId = 1000;
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, highLabelId, 1000000);
        NodeLabelsCache.Client client = cache.newClient();
        int numberOfNodes = 100000;
        int[][] expectedLabels = new int[numberOfNodes][];
        for (int i = 0; i < numberOfNodes; ++i) {
            int[] labels = this.randomLabels(this.random.nextInt(30) + 1, highLabelId);
            expectedLabels[i] = labels;
            cache.put((long)i, this.asLongArray(labels));
        }
        int[] forceCreationOfNewIntArray = new int[]{};
        for (int i = 0; i < numberOfNodes; ++i) {
            int[] labels = cache.get(client, (long)i, forceCreationOfNewIntArray);
            Assert.assertArrayEquals((String)("For node " + i), (int[])expectedLabels[i], (int[])labels);
        }
    }

    @Test
    public void shouldEndTargetArrayWithMinusOne() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, 10);
        NodeLabelsCache.Client client = cache.newClient();
        cache.put(10L, new long[]{5L, 6L, 7L, 8L});
        int[] target = new int[20];
        Assert.assertSame((Object)target, (Object)cache.get(client, 10L, target));
        Assert.assertEquals((long)5L, (long)target[0]);
        Assert.assertEquals((long)6L, (long)target[1]);
        Assert.assertEquals((long)7L, (long)target[2]);
        Assert.assertEquals((long)8L, (long)target[3]);
        Assert.assertEquals((long)-1L, (long)target[4]);
    }

    @Test
    public void shouldReturnEmptyArrayForNodeWithNoLabelsAndNoLabelsWhatsoever() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, 0);
        NodeLabelsCache.Client client = cache.newClient();
        int[] target = new int[3];
        cache.get(client, 0L, target);
        Assert.assertEquals((long)-1L, (long)target[0]);
    }

    @Test
    public void shouldSupportConcurrentGet() throws Throwable {
        int highLabelId = 10;
        int numberOfNodes = 100;
        int[][] expectedLabels = new int[numberOfNodes][];
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, highLabelId);
        for (int i = 0; i < numberOfNodes; ++i) {
            expectedLabels[i] = this.randomLabels(this.random.nextInt(5), highLabelId);
            cache.put((long)i, this.asLongArray(expectedLabels[i]));
        }
        Race getRace = new Race();
        for (int i = 0; i < 10; ++i) {
            getRace.addContestant((Runnable)new LabelGetter(cache, expectedLabels, numberOfNodes));
        }
        getRace.go();
    }

    private long[] asLongArray(int[] labels) {
        long[] result = new long[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            result[i] = labels[i];
        }
        return result;
    }

    private int[] randomLabels(int count, int highId) {
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.random.nextInt(highId);
        }
        return result;
    }

    private static class LabelGetter
    implements Runnable {
        private final NodeLabelsCache cache;
        private final int[][] expectedLabels;
        private final NodeLabelsCache.Client client;
        private final int numberOfNodes;
        private int[] scratch = new int[10];

        LabelGetter(NodeLabelsCache cache, int[][] expectedLabels, int numberOfNodes) {
            this.cache = cache;
            this.client = cache.newClient();
            this.expectedLabels = expectedLabels;
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                int nodeId = ThreadLocalRandom.current().nextInt(this.numberOfNodes);
                this.scratch = this.cache.get(this.client, (long)nodeId, this.scratch);
                this.assertCorrectLabels(nodeId, this.scratch);
            }
        }

        private void assertCorrectLabels(int nodeId, int[] gotten) {
            int[] expected = this.expectedLabels[nodeId];
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((long)expected[i], (long)gotten[i]);
            }
            if (gotten.length != expected.length) {
                Assert.assertEquals((long)-1L, (long)gotten[expected.length]);
            }
        }
    }
}

