/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.ToIntFunction;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Readables;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.PropertyValueRecordSizeCalculator;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Distribution;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.RandomEntityDataGenerator;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.StringDeserialization;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class CsvInputEstimateCalculationIT {
    private static final long NODE_COUNT = 600000L;
    private static final long RELATIONSHIP_COUNT = 600000L;
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldCalculateCorrectEstimates() throws Exception {
        Input input = this.generateData();
        RecordFormats format = Standard.LATEST_RECORD_FORMATS;
        Input.Estimates estimates = input.calculateEstimates((ToIntFunction)new PropertyValueRecordSizeCalculator(format.property().getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER), Integer.parseInt(GraphDatabaseSettings.string_block_size.getDefaultValue()), 0, Integer.parseInt(GraphDatabaseSettings.array_block_size.getDefaultValue()), 0));
        DatabaseLayout databaseLayout = this.directory.databaseLayout();
        Config config = Config.defaults();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            new ParallelBatchImporter(databaseLayout, (FileSystemAbstraction)fs, null, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible(), AdditionalInitialIds.EMPTY, config, format, ImportLogic.NO_MONITOR, (JobScheduler)jobScheduler).doImport(input);
            VersionContextSupplier contextSupplier = EmptyVersionContextSupplier.EMPTY;
            try (PageCache pageCache = new ConfiguringPageCacheFactory((FileSystemAbstraction)fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), contextSupplier, (JobScheduler)jobScheduler).getOrCreatePageCache();
                 NeoStores stores = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs), pageCache, (FileSystemAbstraction)fs, (LogProvider)NullLogProvider.getInstance(), contextSupplier).openAllNeoStores();){
                CsvInputEstimateCalculationIT.assertRoughlyEqual(estimates.numberOfNodes(), stores.getNodeStore().getNumberOfIdsInUse());
                CsvInputEstimateCalculationIT.assertRoughlyEqual(estimates.numberOfRelationships(), stores.getRelationshipStore().getNumberOfIdsInUse());
                CsvInputEstimateCalculationIT.assertRoughlyEqual(estimates.numberOfNodeProperties() + estimates.numberOfRelationshipProperties(), CsvInputEstimateCalculationIT.calculateNumberOfProperties(stores));
            }
            CsvInputEstimateCalculationIT.assertRoughlyEqual(this.propertyStorageSize(), estimates.sizeOfNodeProperties() + estimates.sizeOfRelationshipProperties());
        }
    }

    @Test
    public void shouldCalculateCorrectEstimatesOnEmptyData() throws Exception {
        Groups groups = new Groups();
        List<DataFactory> nodeData = Arrays.asList(this.generateData(DataFactories.defaultFormatNodeFileHeader(), new MutableLong(), 0L, 0L, ":ID", "nodes-1.csv", groups));
        List<DataFactory> relationshipData = Arrays.asList(this.generateData(DataFactories.defaultFormatRelationshipFileHeader(), new MutableLong(), 0L, 0L, ":START_ID,:TYPE,:END_ID", "rels-1.csv", groups));
        CsvInput input = new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, Collector.EMPTY, groups);
        Input.Estimates estimates = input.calculateEstimates((ToIntFunction)new PropertyValueRecordSizeCalculator(Standard.LATEST_RECORD_FORMATS.property().getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER), Integer.parseInt(GraphDatabaseSettings.string_block_size.getDefaultValue()), 0, Integer.parseInt(GraphDatabaseSettings.array_block_size.getDefaultValue()), 0));
        Assert.assertEquals((long)0L, (long)estimates.numberOfNodes());
        Assert.assertEquals((long)0L, (long)estimates.numberOfRelationships());
        Assert.assertEquals((long)0L, (long)estimates.numberOfRelationshipProperties());
        Assert.assertEquals((long)0L, (long)estimates.numberOfNodeProperties());
        Assert.assertEquals((long)0L, (long)estimates.numberOfNodeLabels());
    }

    private long propertyStorageSize() {
        return this.sizeOf(DatabaseFile.PROPERTY_STORE) + this.sizeOf(DatabaseFile.PROPERTY_ARRAY_STORE) + this.sizeOf(DatabaseFile.PROPERTY_STRING_STORE);
    }

    private long sizeOf(DatabaseFile file) {
        return this.directory.databaseLayout().file(file).mapToLong(File::length).sum();
    }

    private Input generateData() throws IOException {
        ArrayList<DataFactory> nodeData = new ArrayList<DataFactory>();
        MutableLong start = new MutableLong();
        Groups groups = new Groups();
        nodeData.add(this.generateData(DataFactories.defaultFormatNodeFileHeader(), start, 200000L, 600000L, ":ID", "nodes-1.csv", groups));
        nodeData.add(this.generateData(DataFactories.defaultFormatNodeFileHeader(), start, 200000L, 600000L, ":ID,:LABEL,name:String,yearOfBirth:int", "nodes-2.csv", groups));
        nodeData.add(this.generateData(DataFactories.defaultFormatNodeFileHeader(), start, 600000L - start.longValue(), 600000L, ":ID,name:String,yearOfBirth:int,other", "nodes-3.csv", groups));
        ArrayList<DataFactory> relationshipData = new ArrayList<DataFactory>();
        start.setValue(0L);
        relationshipData.add(this.generateData(DataFactories.defaultFormatRelationshipFileHeader(), start, 300000L, 600000L, ":START_ID,:TYPE,:END_ID", "relationships-1.csv", groups));
        relationshipData.add(this.generateData(DataFactories.defaultFormatRelationshipFileHeader(), start, 600000L - start.longValue(), 600000L, ":START_ID,:TYPE,:END_ID,prop1,prop2", "relationships-2.csv", groups));
        return new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, Collector.EMPTY, groups);
    }

    private static long calculateNumberOfProperties(NeoStores stores) {
        long count = 0L;
        PropertyRecord record = stores.getPropertyStore().newRecord();
        try (PageCursor cursor = stores.getPropertyStore().openPageCursorForReading(0L);){
            long highId = stores.getPropertyStore().getHighId();
            for (long id = 0L; id < highId; ++id) {
                stores.getPropertyStore().getRecordByCursor(id, (AbstractBaseRecord)record, RecordLoad.CHECK, cursor);
                if (!record.inUse()) continue;
                count += Iterables.count((Iterable)record);
            }
        }
        return count;
    }

    private static void assertRoughlyEqual(long expected, long actual) {
        long diff = Math.abs(expected - actual);
        Assert.assertThat((Object)(expected / 10L), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(diff)));
    }

    private DataFactory generateData(Header.Factory factory, MutableLong start, long count, long nodeCount, String headerString, String fileName, Groups groups) throws IOException {
        File file = this.directory.file(fileName);
        Header header = factory.create(CharSeekers.charSeeker((CharReadable)Readables.wrap((String)headerString), (org.neo4j.csv.reader.Configuration)org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (boolean)false), org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, IdType.INTEGER, groups);
        Distribution<String> distribution = new Distribution<String>(new String[]{"Token"});
        StringDeserialization deserialization = new StringDeserialization(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS);
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
             RandomEntityDataGenerator generator = new RandomEntityDataGenerator(nodeCount, count, Math.toIntExact(count), this.random.seed(), start.longValue(), header, distribution, distribution, 0.0f, 0.0f);
             InputChunk chunk = generator.newChunk();
             InputEntity entity = new InputEntity();){
            out.println(headerString);
            while (generator.next(chunk)) {
                while (chunk.next((InputEntityVisitor)entity)) {
                    out.println(RandomEntityDataGenerator.convert(entity, deserialization, header));
                }
            }
        }
        start.add(count);
        return DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charsets.UTF_8, (File[])new File[]{file});
    }
}

