/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.time.Clock;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class MultiExecutionMonitorTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldCheckMultipleMonitors() {
        FakeClock clock = Clocks.fakeClock();
        TestableMonitor first = new TestableMonitor((Clock)clock, 100L, TimeUnit.MILLISECONDS, "first");
        TestableMonitor other = new TestableMonitor((Clock)clock, 250L, TimeUnit.MILLISECONDS, "other");
        MultiExecutionMonitor multiMonitor = new MultiExecutionMonitor((Clock)clock, new ExecutionMonitor[]{first, other});
        clock.forward(110L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 1, other, 0});
        clock.forward(100L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 2, other, 0});
        clock.forward(45L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 2, other, 1});
    }

    private void expectCallsToCheck(ExecutionMonitor multiMonitor, Object ... alternatingMonitorAndCount) {
        multiMonitor.check(null);
        for (int i = 0; i < alternatingMonitorAndCount.length; ++i) {
            TestableMonitor monitor = (TestableMonitor)((Object)alternatingMonitorAndCount[i++]);
            int count = (Integer)alternatingMonitorAndCount[i];
            Assert.assertThat((Object)monitor.timesPolled, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(count)));
            if (monitor.timesPolled >= count) continue;
            Assert.fail((String)("Polls didn't occur, expected " + Arrays.toString(alternatingMonitorAndCount)));
        }
    }

    private static class TestableMonitor
    extends ExecutionMonitor.Adapter {
        private int timesPolled;
        private final String name;

        TestableMonitor(Clock clock, long interval, TimeUnit unit, String name) {
            super(clock, interval, unit);
            this.name = name;
        }

        public void check(StageExecution execution) {
            ++this.timesPolled;
        }

        public String toString() {
            return "[" + this.name + ":" + this.timesPolled + "]";
        }
    }
}

