/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;

public class CountsRecordStateTest {
    @Test
    public void shouldReportDifferencesBetweenDifferentStates() {
        CountsRecordState oracle = new CountsRecordState();
        CountsRecordState victim = new CountsRecordState();
        oracle.incrementNodeCount(17L, 5L);
        victim.incrementNodeCount(17L, 3L);
        oracle.incrementNodeCount(12L, 9L);
        victim.incrementNodeCount(12L, 9L);
        oracle.incrementRelationshipCount(1L, 2, 3L, 19L);
        victim.incrementRelationshipCount(1L, 2, 3L, 22L);
        oracle.incrementRelationshipCount(1L, 4, 3L, 25L);
        victim.incrementRelationshipCount(1L, 4, 3L, 25L);
        Set differences = Iterables.asSet((Iterable)oracle.verify((CountsVisitor.Visitable)victim));
        Assert.assertEquals((Object)differences, (Object)Iterators.asSet((Object[])new CountsRecordState.Difference[]{new CountsRecordState.Difference((CountsKey)CountsKeyFactory.nodeKey((long)17L), 0L, 5L, 0L, 3L), new CountsRecordState.Difference((CountsKey)CountsKeyFactory.relationshipKey((long)1L, (int)2, (long)3L), 0L, 19L, 0L, 22L)}));
    }

    @Test
    public void shouldNotReportAnythingForEqualStates() {
        CountsRecordState oracle = new CountsRecordState();
        CountsRecordState victim = new CountsRecordState();
        oracle.incrementNodeCount(17L, 5L);
        victim.incrementNodeCount(17L, 5L);
        oracle.incrementNodeCount(12L, 9L);
        victim.incrementNodeCount(12L, 9L);
        oracle.incrementRelationshipCount(1L, 4, 3L, 25L);
        victim.incrementRelationshipCount(1L, 4, 3L, 25L);
        List differences = oracle.verify((CountsVisitor.Visitable)victim);
        Assert.assertTrue((String)differences.toString(), (boolean)differences.isEmpty());
    }
}

