/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class CountsStoreTransactionApplierTest {
    @Test
    public void shouldNotifyCacheAccessOnHowManyUpdatesOnCountsWeHadSoFar() throws Exception {
        CountsTracker tracker = (CountsTracker)Mockito.mock(CountsTracker.class);
        CountsAccessor.Updater updater = (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class);
        Mockito.when((Object)tracker.apply(ArgumentMatchers.anyLong())).thenReturn(Optional.of(updater));
        CountsStoreBatchTransactionApplier applier = new CountsStoreBatchTransactionApplier(tracker, TransactionApplicationMode.INTERNAL);
        try (TransactionApplier txApplier = applier.startTx((CommandsToApply)new TransactionToApply(null, 2L));){
            txApplier.visitNodeCountsCommand(new Command.NodeCountsCommand(-1, 1L));
        }
        ((CountsAccessor.Updater)Mockito.verify((Object)updater, (VerificationMode)Mockito.times((int)1))).incrementNodeCount(-1L, 1L);
    }
}

