/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NativeIndexPopulatorTests<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexTestUtil<KEY, VALUE> {
    private static final int LARGE_AMOUNT_OF_UPDATES = 1000;
    static final NodePropertyAccessor null_property_accessor = (nodeId, propKeyId) -> {
        throw new RuntimeException("Did not expect an attempt to go to store");
    };
    NativeIndexPopulator<KEY, VALUE> populator;

    @Before
    public void setupPopulator() throws IOException {
        this.populator = this.createPopulator();
    }

    abstract NativeIndexPopulator<KEY, VALUE> createPopulator() throws IOException;

    @Test
    public void createShouldCreateFile() {
        this.assertFileNotPresent();
        this.populator.create();
        this.assertFilePresent();
        this.populator.close(true);
    }

    @Test
    public void createShouldClearExistingFile() throws Exception {
        byte[] someBytes = this.fileWithContent();
        this.populator.create();
        try (StoreChannel r = this.fs.open(this.getIndexFile(), OpenMode.READ);){
            byte[] firstBytes = new byte[someBytes.length];
            r.readAll(ByteBuffer.wrap(firstBytes));
            Assert.assertNotEquals((String)"Expected previous file content to have been cleared but was still there", (Object)someBytes, (Object)firstBytes);
        }
        this.populator.close(true);
    }

    @Test
    public void dropShouldDeleteExistingFile() {
        this.populator.create();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void dropShouldSucceedOnNonExistentFile() {
        this.assertFileNotPresent();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void addShouldHandleEmptyCollection() throws Exception {
        this.populator.create();
        List updates = Collections.emptyList();
        this.populator.add(updates);
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
    }

    @Test
    public void addShouldApplyAllUpdatesOnce() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.populator.add(Arrays.asList(updates));
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterShouldApplyUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterMustThrowIfProcessAfterClose() throws Exception {
        this.populator.create();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);
        updater.close();
        try {
            updater.process(this.valueCreatorUtil.add(1L, Values.of((Object)Long.MAX_VALUE)));
            Assert.fail((String)"Expected process to throw on closed updater");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.populator.close(true);
    }

    @Test
    public void shouldApplyInterleavedUpdatesFromAddAndUpdater() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.applyInterleaved(updates, this.populator);
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void successfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assert.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(true);
        existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        Assert.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    public void successfulCloseMustMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(true);
        this.assertHeader(InternalIndexState.ONLINE, null, false);
    }

    @Test
    public void unsuccessfulCloseMustSucceedWithoutMarkAsFailed() {
        this.populator.create();
        this.populator.close(false);
    }

    @Test
    public void unsuccessfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assert.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(false);
        existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        Assert.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    public void unsuccessfulCloseMustNotMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(false);
        this.assertHeader(InternalIndexState.POPULATING, null, false);
    }

    @Test
    public void closeMustWriteFailureMessageAfterMarkedAsFailed() throws Exception {
        this.populator.create();
        String failureMessage = "Fly, you fools!";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    public void closeMustWriteFailureMessageAfterMarkedAsFailedWithLongMessage() throws Exception {
        this.populator.create();
        String failureMessage = this.longString(this.pageCache.pageSize());
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, true);
    }

    @Test
    public void successfulCloseMustThrowIfMarkedAsFailed() {
        this.populator.create();
        this.populator.markAsFailed("");
        try {
            this.populator.close(true);
            Assert.fail((String)"Expected successful close to fail after markedAsFailed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Expected cause to contain " + IllegalStateException.class), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalStateException.class}));
        }
        this.populator.close(false);
    }

    @Test
    public void shouldApplyLargeAmountOfInterleavedRandomUpdates() throws Exception {
        this.populator.create();
        this.random.reset();
        Random updaterRandom = new Random(this.random.seed());
        Iterator<IndexEntryUpdate<IndexDescriptor>> updates = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int count = this.interleaveLargeAmountOfUpdates(updaterRandom, updates);
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.random.reset();
        this.verifyUpdates(this.valueCreatorUtil.randomUpdateGenerator(this.random), count);
    }

    @Test
    public void dropMustSucceedAfterSuccessfulClose() {
        this.populator.create();
        this.populator.close(true);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void dropMustSucceedAfterUnsuccessfulClose() {
        this.populator.create();
        this.populator.close(false);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void successfulCloseMustThrowWithoutPriorSuccessfulCreate() {
        this.assertFileNotPresent();
        try {
            this.populator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Expected cause to contain " + IllegalStateException.class), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalStateException.class}));
        }
    }

    @Test
    public void unsuccessfulCloseMustSucceedWithoutSuccessfulPriorCreate() throws Exception {
        this.assertFileNotPresent();
        String failureMessage = "There is no spoon";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    public void successfulCloseMustThrowAfterDrop() {
        this.populator.create();
        this.populator.drop();
        try {
            this.populator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Expected cause to contain " + IllegalStateException.class), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalStateException.class}));
        }
    }

    @Test
    public void unsuccessfulCloseMustThrowAfterDrop() {
        this.populator.create();
        this.populator.drop();
        try {
            this.populator.close(false);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Expected cause to contain " + IllegalStateException.class), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalStateException.class}));
        }
    }

    private int interleaveLargeAmountOfUpdates(Random updaterRandom, Iterator<IndexEntryUpdate<IndexDescriptor>> updates) throws IndexEntryConflictException {
        int count = 0;
        for (int i = 0; i < 1000; ++i) {
            if ((double)updaterRandom.nextFloat() < 0.1) {
                try (IndexUpdater indexUpdater = this.populator.newPopulatingUpdater(null_property_accessor);){
                    int numberOfUpdaterUpdates = updaterRandom.nextInt(100);
                    for (int j = 0; j < numberOfUpdaterUpdates; ++j) {
                        indexUpdater.process(updates.next());
                        ++count;
                    }
                }
            }
            this.populator.add(Collections.singletonList(updates.next()));
            ++count;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertHeader(InternalIndexState expectedState, String failureMessage, boolean messageTruncated) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        try (GBPTree ignored = new GBPTree(this.pageCache, this.getIndexFile(), (Layout)this.layout, 0, GBPTree.NO_MONITOR, (Header.Reader)headerReader, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.immediate());){
            switch (expectedState) {
                case ONLINE: {
                    Assert.assertEquals((String)"Index was not marked as online when expected not to be.", (long)1L, (long)headerReader.state);
                    Assert.assertNull((String)"Expected failure message to be null when marked as online.", (Object)headerReader.failureMessage);
                    return;
                }
                case FAILED: {
                    Assert.assertEquals((String)"Index was marked as online when expected not to be.", (long)0L, (long)headerReader.state);
                    if (messageTruncated) {
                        Assert.assertTrue((headerReader.failureMessage.length() < failureMessage.length() ? 1 : 0) != 0);
                        Assert.assertTrue((boolean)failureMessage.startsWith(headerReader.failureMessage));
                        return;
                    } else {
                        Assert.assertEquals((Object)failureMessage, (Object)headerReader.failureMessage);
                        return;
                    }
                }
                case POPULATING: {
                    Assert.assertEquals((String)"Index was not left as populating when expected to be.", (long)2L, (long)headerReader.state);
                    Assert.assertNull((String)"Expected failure message to be null when marked as populating.", (Object)headerReader.failureMessage);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected index state " + expectedState);
                }
            }
        }
    }

    private String longString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    private void applyInterleaved(IndexEntryUpdate<IndexDescriptor>[] updates, NativeIndexPopulator<KEY, VALUE> populator) throws IndexEntryConflictException {
        boolean useUpdater = true;
        ArrayList<IndexEntryUpdate<IndexDescriptor>> populatorBatch = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        IndexUpdater updater = populator.newPopulatingUpdater(null_property_accessor);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            if (this.random.nextInt(100) < 20) {
                if (useUpdater) {
                    updater.close();
                    populatorBatch = new ArrayList();
                } else {
                    populator.add(populatorBatch);
                    updater = populator.newPopulatingUpdater(null_property_accessor);
                }
                boolean bl = useUpdater = !useUpdater;
            }
            if (useUpdater) {
                updater.process(update);
                continue;
            }
            populatorBatch.add(update);
        }
        if (useUpdater) {
            updater.close();
        } else {
            populator.add(populatorBatch);
        }
    }

    private void verifyUpdates(Iterator<IndexEntryUpdate<IndexDescriptor>> indexEntryUpdateIterator, int count) throws IOException {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        for (int i = 0; i < count; ++i) {
            updates[i] = indexEntryUpdateIterator.next();
        }
        this.verifyUpdates(updates);
    }

    private byte[] fileWithContent() throws IOException {
        int size = 1000;
        this.fs.mkdirs(this.getIndexFile().getParentFile());
        try (StoreChannel storeChannel = this.fs.create(this.getIndexFile());){
            byte[] someBytes = new byte[size];
            this.random.nextBytes(someBytes);
            storeChannel.writeAll(ByteBuffer.wrap(someBytes));
            byte[] byArray = someBytes;
            return byArray;
        }
    }

    public static abstract class NonUnique<K extends NativeIndexKey<K>, V extends NativeIndexValue>
    extends NativeIndexPopulatorTests<K, V> {
        @Test
        public void addShouldApplyDuplicateValues() throws Exception {
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
            this.populator.add(Arrays.asList(updates));
            this.populator.scanCompleted(PhaseTracker.nullInstance);
            this.populator.close(true);
            this.verifyUpdates(updates);
        }

        @Test
        public void updaterShouldApplyDuplicateValues() throws Exception {
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
            try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
                for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                    updater.process(update);
                }
            }
            this.populator.scanCompleted(PhaseTracker.nullInstance);
            this.populator.close(true);
            this.verifyUpdates(updates);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void shouldSampleUpdatesIfConfiguredForOnlineSampling() throws Exception {
            try {
                Value[] updates;
                this.populator.create();
                IndexEntryUpdate<IndexDescriptor>[] scanUpdates = this.valueCreatorUtil.someUpdates(this.random);
                this.populator.add(Arrays.asList(scanUpdates));
                Iterator<IndexEntryUpdate<IndexDescriptor>> generator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
                updates = new Value[]{generator.next().values()[0], generator.next().values()[0], updates[1], generator.next().values()[0], updates[3]};
                try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
                    long nodeId = 1000L;
                    for (Value value : updates) {
                        IndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.add(nodeId++, value);
                        updater.process(update);
                    }
                }
                this.populator.scanCompleted(PhaseTracker.nullInstance);
                IndexSample sample = this.populator.sampleResult();
                Value[] allValues = Arrays.copyOf(updates, updates.length + scanUpdates.length);
                System.arraycopy(this.asValues(scanUpdates), 0, allValues, updates.length, scanUpdates.length);
                Assert.assertEquals((long)(updates.length + scanUpdates.length), (long)sample.sampleSize());
                Assert.assertEquals((long)ValueCreatorUtil.countUniqueValues(allValues), (long)sample.uniqueValues());
                Assert.assertEquals((long)(updates.length + scanUpdates.length), (long)sample.indexSize());
            }
            finally {
                this.populator.close(true);
            }
        }

        private Value[] asValues(IndexEntryUpdate<IndexDescriptor>[] updates) {
            Value[] values = new Value[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                values[i] = updates[i].values()[0];
            }
            return values;
        }
    }

    public static abstract class Unique<K extends NativeIndexKey<K>, V extends NativeIndexValue>
    extends NativeIndexPopulatorTests<K, V> {
        @Test
        public void addShouldThrowOnDuplicateValues() {
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
            try {
                this.populator.add(Arrays.asList(updates));
                this.populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Updates should have conflicted");
            }
            catch (IndexEntryConflictException indexEntryConflictException) {
            }
            finally {
                this.populator.close(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void updaterShouldThrowOnDuplicateValues() throws Exception {
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
            IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
            try {
                updater.close();
                this.populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Updates should have conflicted");
            }
            catch (Exception e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IndexEntryConflictException.class}));
            }
            finally {
                this.populator.close(true);
            }
        }

        @Test
        public void shouldSampleUpdates() throws Exception {
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
            this.populator.add(Arrays.asList(updates));
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                this.populator.includeSample(update);
            }
            this.populator.scanCompleted(PhaseTracker.nullInstance);
            IndexSample sample = this.populator.sampleResult();
            Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
            Assert.assertEquals((long)updates.length, (long)sample.uniqueValues());
            Assert.assertEquals((long)updates.length, (long)sample.indexSize());
            this.populator.close(true);
        }
    }
}

