/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexProviderTests;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class NativeIndexProviderTest
extends NativeIndexProviderTests {
    @Parameterized.Parameter
    public String name;
    @Parameterized.Parameter(value=1)
    public ProviderFactory providerFactory;
    @Parameterized.Parameter(value=2)
    public InternalIndexState expectedStateOnNonExistingSubIndex;
    @Parameterized.Parameter(value=3)
    public Value someValue;

    @Parameterized.Parameters(name="{index} {0}")
    public static Object[][] data() {
        return new Object[][]{{"Number", NumberIndexProvider::new, InternalIndexState.POPULATING, Values.of((Object)1)}, {"String", StringIndexProvider::new, InternalIndexState.POPULATING, Values.of((Object)"string")}, {"Spatial", NativeIndexProviderTest.spatialProviderFactory(), InternalIndexState.ONLINE, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0})}, {"Temporal", TemporalIndexProvider::new, InternalIndexState.ONLINE, DateValue.date((int)1, (int)1, (int)1)}, {"Generic", NativeIndexProviderTest.genericProviderFactory(), InternalIndexState.POPULATING, Values.of((Object)1)}};
    }

    private static ProviderFactory genericProviderFactory() {
        return (pageCache, fs, dir, monitor, collector, readOnly) -> new GenericNativeIndexProvider(dir, pageCache, fs, monitor, collector, readOnly, Config.defaults());
    }

    private static ProviderFactory spatialProviderFactory() {
        return (pageCache, fs, dir, monitor, collector, readOnly) -> new SpatialIndexProvider(pageCache, fs, dir, monitor, collector, readOnly, Config.defaults());
    }

    @Override
    protected InternalIndexState expectedStateOnNonExistingSubIndex() {
        return this.expectedStateOnNonExistingSubIndex;
    }

    @Override
    protected Value someValue() {
        return this.someValue;
    }

    @Override
    IndexProvider newProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory dir, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector collector, boolean readOnly) {
        return this.providerFactory.create(pageCache, fs, dir, monitor, collector, readOnly);
    }

    @FunctionalInterface
    private static interface ProviderFactory {
        public IndexProvider create(PageCache var1, FileSystemAbstraction var2, IndexDirectoryStructure.Factory var3, IndexProvider.Monitor var4, RecoveryCleanupWorkCollector var5, boolean var6);
    }
}

