/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordBuilders;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordMatchers;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipCreator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.storageengine.api.lock.ResourceLocker;

public class RelationshipCreatorTest {
    private AbstractBaseRecord[] givenState;
    private RecordChangeSet changeset;
    private int denseNodeThreshold = 10;

    @Test
    public void newRelWithNoPriorRels() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, new Consumer[0]), RecordBuilders.node(1L, new Consumer[0])});
        this.createRelationshipBetween(0L, 1L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(0L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))}));
    }

    @Test
    public void selfRelWithNoPriorRels() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, new Consumer[0])});
        this.createRelationshipBetween(0L, 0L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))}));
    }

    @Test
    public void sourceHas1PriorRel() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(0L)), RecordBuilders.node(2L, new Consumer[0]), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.createRelationshipBetween(0L, 2L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(1L)), RecordBuilders.node(2L, RecordBuilders.nextRel(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sPrev(1L), RecordBuilders.tCount(1L)), RecordBuilders.rel(1L, RecordBuilders.from(0L), RecordBuilders.to(2L), RecordBuilders.sCount(2L), RecordBuilders.sNext(0L), RecordBuilders.tCount(1L))}));
    }

    @Test
    public void targetHas1PriorRel() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(0L)), RecordBuilders.node(2L, new Consumer[0]), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.createRelationshipBetween(2L, 0L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(1L)), RecordBuilders.node(2L, RecordBuilders.nextRel(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sPrev(1L), RecordBuilders.tCount(1L)), RecordBuilders.rel(1L, RecordBuilders.from(2L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tNext(0L), RecordBuilders.tCount(2L))}));
    }

    @Test
    public void sourceAndTargetShare1PriorRel() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(0L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.createRelationshipBetween(0L, 1L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(1L)), RecordBuilders.node(1L, RecordBuilders.nextRel(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sPrev(1L), RecordBuilders.tPrev(1L)), RecordBuilders.rel(1L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(2L), RecordBuilders.sNext(0L), RecordBuilders.tCount(2L), RecordBuilders.tNext(0L))}));
    }

    @Test
    public void selfRelWith1PriorRel() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.createRelationshipBetween(0L, 0L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sPrev(1L), RecordBuilders.tPrev(1L)), RecordBuilders.rel(1L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(2L), RecordBuilders.sNext(0L), RecordBuilders.tCount(2L), RecordBuilders.tNext(0L))}));
    }

    @Test
    public void selfRelUpgradesToDense() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.denseNodeThreshold = 1;
        this.createRelationshipBetween(0L, 0L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.group(0L)), RecordBuilders.relGroup(0L, RecordBuilders.owningNode(0L), RecordBuilders.firstLoop(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sPrev(1L), RecordBuilders.tPrev(1L)), RecordBuilders.rel(1L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(2L), RecordBuilders.sNext(0L), RecordBuilders.tCount(2L), RecordBuilders.tNext(0L))}));
    }

    @Test
    public void sourceNodeUpdatesToDense() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, new Consumer[0]), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.denseNodeThreshold = 1;
        this.createRelationshipBetween(0L, 1L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.group(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(1L)), RecordBuilders.relGroup(0L, RecordBuilders.owningNode(0L), RecordBuilders.firstLoop(0L), RecordBuilders.firstOut(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L)), RecordBuilders.rel(1L, RecordBuilders.from(0L), RecordBuilders.to(1L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))}));
    }

    @Test
    public void targetNodeUpdatesToDense() throws Exception {
        this.givenState(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.nextRel(0L)), RecordBuilders.node(1L, new Consumer[0]), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))});
        this.denseNodeThreshold = 1;
        this.createRelationshipBetween(1L, 0L);
        Assert.assertThat((Object)this.changeset, RecordMatchers.containsChanges(new AbstractBaseRecord[]{RecordBuilders.node(0L, RecordBuilders.group(0L)), RecordBuilders.node(1L, RecordBuilders.nextRel(1L)), RecordBuilders.relGroup(0L, RecordBuilders.owningNode(0L), RecordBuilders.firstLoop(0L), RecordBuilders.firstIn(1L)), RecordBuilders.rel(0L, RecordBuilders.from(0L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L)), RecordBuilders.rel(1L, RecordBuilders.from(1L), RecordBuilders.to(0L), RecordBuilders.sCount(1L), RecordBuilders.tCount(1L))}));
    }

    private void givenState(AbstractBaseRecord ... records) {
        this.givenState = records;
        this.changeset = RecordBuilders.newChangeSet(this.givenState);
    }

    private void createRelationshipBetween(long fromNode, long toNode) {
        NoOpClient locks = new NoOpClient();
        RelationshipCreator logic = new RelationshipCreator(RecordBuilders.newRelGroupGetter(this.givenState), this.denseNodeThreshold);
        logic.relationshipCreate(this.nextRelId(this.givenState), 0, fromNode, toNode, (RecordAccessSet)this.changeset, (ResourceLocker)locks);
    }

    private long nextRelId(AbstractBaseRecord[] existingRecords) {
        return RecordBuilders.filterType(existingRecords, RelationshipRecord.class).map(AbstractBaseRecord::getId).max(Long::compareTo).orElse(-1L) + 1L;
    }
}

