/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class DataSourceManagerTest {
    @Inject
    private TestDirectory testDirectory;

    DataSourceManagerTest() {
    }

    @Test
    void shouldCallListenersOnStart() {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        manager.addListener(listener);
        manager.start();
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)ArgumentMatchers.any(NeoStoreDataSource.class));
    }

    @Test
    void shouldCallListenersWhenAddedIfManagerAlreadyStarted() {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        manager.start();
        manager.addListener(listener);
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)ArgumentMatchers.any(NeoStoreDataSource.class));
    }

    @Test
    void shouldCallListenersOnDataSourceRegistrationIfManagerAlreadyStarted() {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.addListener(listener);
        manager.start();
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)ArgumentMatchers.any(NeoStoreDataSource.class));
    }

    @Test
    void shouldSupportMultipleStartStopCycles() throws Throwable {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        manager.register(dataSource);
        manager.init();
        manager.start();
        manager.stop();
        manager.start();
        ((NeoStoreDataSource)Mockito.verify((Object)dataSource, (VerificationMode)Mockito.times((int)2))).start();
    }

    @Test
    void provideAccessOnlyToActiveDatabase() {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        NeoStoreDataSource dataSource1 = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        NeoStoreDataSource dataSource2 = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource1.getDatabaseLayout()).thenReturn((Object)this.testDirectory.databaseLayout());
        Mockito.when((Object)dataSource2.getDatabaseLayout()).thenReturn((Object)this.testDirectory.databaseLayout("somethingElse"));
        manager.register(dataSource1);
        manager.register(dataSource2);
        Assertions.assertEquals((Object)dataSource1, (Object)manager.getDataSource());
    }

    @Test
    void illegalStateWhenActiveDatabaseNotFound() {
        DataSourceManager manager = DataSourceManagerTest.createDataSourceManager();
        Assertions.assertThrows(IllegalStateException.class, () -> ((DataSourceManager)manager).getDataSource());
    }

    private static DataSourceManager createDataSourceManager() {
        return new DataSourceManager(Config.defaults());
    }
}

