/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.BiFunction;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.test.Race;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

public abstract class PageCacheNumberArrayConcurrencyTest {
    protected static final int COUNT = 100;
    protected static final int LAPS = 2000;
    protected static final int CONTESTANTS = 10;
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory();
    protected final RandomRule random = new RandomRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.dir).around((TestRule)this.random).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldHandleConcurrentAccessToSameData() throws Throwable {
        this.doRace(this::wholeFileRacer);
    }

    @Test
    public void shouldHandleConcurrentAccessToDifferentData() throws Throwable {
        this.doRace(this::fileRangeRacer);
    }

    private void doRace(BiFunction<NumberArray, Integer, Runnable> contestantCreator) throws Throwable {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        PagedFile file = pageCache.map(this.dir.file("file"), pageCache.pageSize(), new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE});
        Race race = new Race();
        try (NumberArray array = this.getNumberArray(file);){
            for (int i = 0; i < 10; ++i) {
                race.addContestant(contestantCreator.apply(array, i));
            }
            race.go();
        }
    }

    protected abstract Runnable fileRangeRacer(NumberArray var1, int var2);

    protected abstract NumberArray getNumberArray(PagedFile var1) throws IOException;

    protected abstract Runnable wholeFileRacer(NumberArray var1, int var2);
}

