/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Distribution;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.input.RandomEntityDataGenerator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.values.storable.Value;

public class DataGeneratorInput
implements Input {
    private final long nodes;
    private final long relationships;
    private final IdType idType;
    private final Collector badCollector;
    private final long seed;
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private final Distribution<String> labels;
    private final Distribution<String> relationshipTypes;
    private final float factorBadNodeData;
    private final float factorBadRelationshipData;
    private final long startId;
    private final Groups groups = new Groups();

    public DataGeneratorInput(long nodes, long relationships, IdType idType, Collector badCollector, long seed, long startId, Header nodeHeader, Header relationshipHeader, int labelCount, int relationshipTypeCount, float factorBadNodeData, float factorBadRelationshipData) {
        this.nodes = nodes;
        this.relationships = relationships;
        this.idType = idType;
        this.badCollector = badCollector;
        this.seed = seed;
        this.startId = startId;
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.factorBadNodeData = factorBadNodeData;
        this.factorBadRelationshipData = factorBadRelationshipData;
        this.labels = new Distribution<String>(DataGeneratorInput.tokens("Label", labelCount));
        this.relationshipTypes = new Distribution<String>(DataGeneratorInput.tokens("TYPE", relationshipTypeCount));
    }

    public InputIterable nodes() {
        return () -> new RandomEntityDataGenerator(this.nodes, this.nodes, 10000, this.seed, this.startId, this.nodeHeader, this.labels, this.relationshipTypes, this.factorBadNodeData, this.factorBadRelationshipData);
    }

    public InputIterable relationships() {
        return () -> new RandomEntityDataGenerator(this.nodes, this.relationships, 10000, this.seed, this.startId, this.relationshipHeader, this.labels, this.relationshipTypes, this.factorBadNodeData, this.factorBadRelationshipData);
    }

    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return this.idType.idMapper(numberArrayFactory, this.groups);
    }

    public Collector badCollector() {
        return this.badCollector;
    }

    public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) {
        int sampleSize = 100;
        InputEntity[] nodeSample = this.sample(this.nodes(), sampleSize);
        double labelsPerNodeEstimate = DataGeneratorInput.sampleLabels(nodeSample);
        double[] nodePropertyEstimate = DataGeneratorInput.sampleProperties(nodeSample, valueSizeCalculator);
        double[] relationshipPropertyEstimate = DataGeneratorInput.sampleProperties(this.sample(this.relationships(), sampleSize), valueSizeCalculator);
        return Inputs.knownEstimates((long)this.nodes, (long)this.relationships, (long)((long)((double)this.nodes * nodePropertyEstimate[0])), (long)((long)((double)this.relationships * relationshipPropertyEstimate[0])), (long)((long)((double)this.nodes * nodePropertyEstimate[1])), (long)((long)((double)this.relationships * relationshipPropertyEstimate[1])), (long)((long)((double)this.nodes * labelsPerNodeEstimate)));
    }

    /*
     * Exception decompiling
     */
    private InputEntity[] sample(InputIterable source, int size) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static double sampleLabels(InputEntity[] nodes) {
        int labels = 0;
        for (InputEntity node : nodes) {
            labels += node.labels().length;
        }
        return (double)labels / (double)nodes.length;
    }

    private static double[] sampleProperties(InputEntity[] sample, ToIntFunction<Value[]> valueSizeCalculator) {
        int propertiesPerEntity = sample[0].propertyCount();
        long propertiesSize = 0L;
        for (InputEntity entity : sample) {
            propertiesSize += (long)Inputs.calculatePropertySize((InputEntity)entity, valueSizeCalculator);
        }
        double propertySizePerEntity = (double)propertiesSize / (double)sample.length;
        return new double[]{propertiesPerEntity, propertySizePerEntity};
    }

    public static Header sillyNodeHeader(IdType idType, Extractors extractors) {
        return new Header(new Header.Entry[]{new Header.Entry(null, Type.ID, null, idType.extractor(extractors)), new Header.Entry("name", Type.PROPERTY, null, extractors.string()), new Header.Entry("age", Type.PROPERTY, null, (Extractor)extractors.int_()), new Header.Entry("something", Type.PROPERTY, null, extractors.string()), new Header.Entry(null, Type.LABEL, null, extractors.stringArray())});
    }

    public static Header bareboneNodeHeader(IdType idType, Extractors extractors) {
        return DataGeneratorInput.bareboneNodeHeader(null, idType, extractors, new Header.Entry[0]);
    }

    public static Header bareboneNodeHeader(String idKey, IdType idType, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(idKey, Type.ID, null, idType.extractor(extractors)));
        entries.add(new Header.Entry(null, Type.LABEL, null, extractors.stringArray()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[entries.size()]));
    }

    public static Header bareboneRelationshipHeader(IdType idType, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(null, Type.START_ID, null, idType.extractor(extractors)));
        entries.add(new Header.Entry(null, Type.END_ID, null, idType.extractor(extractors)));
        entries.add(new Header.Entry(null, Type.TYPE, null, extractors.string()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[entries.size()]));
    }

    private static String[] tokens(String prefix, int count) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = prefix + (i + 1);
        }
        return result;
    }
}

