/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintCreator;

public class NodePropertyExistenceConstraintCreator
extends BaseNodeConstraintCreator {
    private final List<String> propertyKeys;

    NodePropertyExistenceConstraintCreator(InternalSchemaActions actions, String name, Label label, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, label, indexType, indexConfig);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        List<String> keys = List.of(propertyKey);
        if (this.propertyKeys.equals(keys)) {
            return new NodeKeyConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, this.indexType, this.indexConfig);
        }
        throw new UnsupportedOperationException("You cannot create a constraint on two different sets of property keys: " + this.propertyKeys + " vs. " + keys + ".");
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one property existence constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyIsNodeKey(String propertyKey) {
        return this.assertPropertyIsUnique(propertyKey);
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new NodePropertyExistenceConstraintCreator(this.actions, name, this.label, this.propertyKeys, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new NodePropertyExistenceConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new NodePropertyExistenceConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, this.indexType, IndexConfig.from(indexConfiguration));
    }

    @Override
    public ConstraintDefinition create() {
        if (this.indexType != null) {
            throw new IllegalArgumentException("Node property existence constraints cannot be created with an index type. Was given index type " + this.indexType + ".");
        }
        if (this.indexConfig != null) {
            throw new IllegalArgumentException("Node property existence constraints cannot be created with an index configuration.");
        }
        return this.actions.createPropertyExistenceConstraint(this.name, this.label, this.propertyKeys.toArray(new String[0]));
    }
}

