/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.storable.Value;

public class NativeHitIndexProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexProgressor<KEY, VALUE> {
    NativeHitIndexProgressor(Seeker<KEY, VALUE> seeker, IndexProgressor.EntityValueClient client) {
        super(seeker, client);
    }

    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeIndexKey key = (NativeIndexKey)((Object)this.seeker.key());
                Value[] values = this.extractValues(key);
                if (!this.acceptValue(values) || !this.client.acceptEntity(key.getEntityId(), Float.NaN, values)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected boolean acceptValue(Value[] values) {
        return true;
    }
}

