/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.index.label.LabelScan;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.CursorPropertyAccessor;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.LockingNodeUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.NodeCursorScan;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexCursorScan;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.kernel.impl.newapi.RelationshipCursorScan;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
SchemaRead,
Procedures,
Locks,
AssertOpen,
LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker<DefaultNodeValueIndexCursor>,
QueryContext {
    private final StorageReader storageReader;
    protected final DefaultPooledCursors cursors;
    final KernelTransactionImplementation ktx;

    Read(StorageReader storageReader, DefaultPooledCursors cursors, KernelTransactionImplementation ktx) {
        this.storageReader = storageReader;
        this.cursors = cursors;
        this.ktx = ktx;
    }

    public final void nodeIndexSeek(IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can only be performed on node indexes: " + index);
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        IndexProgressor.EntityValueClient withFullPrecision = this.injectFullValuePrecision(client, query, indexSession.reader);
        indexSession.reader.query((QueryContext)this, withFullPrecision, indexOrder, needsValues, query);
    }

    public final void relationshipIndexSeek(IndexDescriptor index, RelationshipIndexCursor cursor, IndexQuery ... query) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
        this.ktx.assertOpen();
        if (index.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can only be performed on node indexes: " + index);
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        IndexReader reader = this.indexReader(index, false);
        client.setRead(this);
        IndexProgressor.EntityValueClient withFullPrecision = this.injectFullValuePrecision(client, query, reader);
        reader.query((QueryContext)this, withFullPrecision, IndexOrder.NONE, false, query);
    }

    public void nodeIndexDistinctValues(IndexDescriptor index, NodeValueIndexCursor cursor, boolean needsValues) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        DefaultNodeValueIndexCursor cursorImpl = (DefaultNodeValueIndexCursor)cursor;
        cursorImpl.disableSecurity();
        IndexReader reader = this.indexReader(index, true);
        cursorImpl.setRead(this);
        CursorPropertyAccessor accessor = new CursorPropertyAccessor(this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), this);
        reader.distinctValues((IndexProgressor.EntityValueClient)cursorImpl, (NodePropertyAccessor)accessor, needsValues);
    }

    private IndexProgressor.EntityValueClient injectFullValuePrecision(IndexProgressor.EntityValueClient cursor, IndexQuery[] query, IndexReader reader) {
        IndexProgressor.EntityValueClient target = cursor;
        if (!reader.hasFullValuePrecision(query)) {
            IndexQuery[] filters = new IndexQuery[query.length];
            int count = 0;
            block4: for (int i = 0; i < query.length; ++i) {
                IndexQuery q = query[i];
                switch (q.type()) {
                    case range: {
                        ValueGroup valueGroup = q.valueGroup();
                        if (valueGroup != ValueGroup.NUMBER && valueGroup != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(new IndexQuery[]{q})) continue block4;
                        filters[i] = q;
                        ++count;
                        continue block4;
                    }
                    case exact: {
                        Value value = ((IndexQuery.ExactPredicate)q).value();
                        if (value.valueGroup() != ValueGroup.NUMBER && !Values.isArrayValue((Value)value) && value.valueGroup() != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(new IndexQuery[]{q})) continue block4;
                        filters[i] = q;
                        ++count;
                        continue block4;
                    }
                }
            }
            if (count > 0) {
                target = new NodeValueClientFilter(target, this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), this, filters);
            }
        }
        return target;
    }

    public org.neo4j.internal.kernel.api.Read getRead() {
        return this;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public ReadableTransactionState getTransactionStateOrNull() {
        return this.hasTxStateWithChanges() ? this.txState() : null;
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, IndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        Locks.Client locks = this.ktx.statementLocks().optimistic();
        LockTracer lockTracer = this.ktx.lockTracer();
        return LockingNodeUniqueIndexSeek.apply(locks, lockTracer, (DefaultNodeValueIndexCursor)cursor, this, this, index, predicates);
    }

    @Override
    public void nodeIndexSeekWithFreshIndexReader(DefaultNodeValueIndexCursor cursor, IndexReader indexReader, IndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        IndexProgressor.EntityValueClient target = this.injectFullValuePrecision(cursor, (IndexQuery[])query, indexReader);
        indexReader.query((QueryContext)this, target, IndexOrder.NONE, false, (IndexQuery[])query);
    }

    public final void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues) throws KernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can only be performed on node indexes: " + index);
        }
        int firstProperty = indexSession.reference.schema().getPropertyIds()[0];
        DefaultNodeValueIndexCursor cursorImpl = (DefaultNodeValueIndexCursor)cursor;
        cursorImpl.setRead(this);
        indexSession.reader.query((QueryContext)this, (IndexProgressor.EntityValueClient)cursorImpl, indexOrder, needsValues, new IndexQuery[]{IndexQuery.exists((int)firstProperty)});
    }

    public final void nodeLabelScan(int label, NodeLabelIndexCursor cursor) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        LabelScan labelScan = this.labelScanReader().nodeLabelScan(label);
        indexCursor.scan(labelScan.initialize(indexCursor.nodeLabelClient()), label);
    }

    public final Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        this.ktx.assertOpen();
        return new NodeLabelIndexCursorScan(this, label, this.labelScanReader().nodeLabelScan(label));
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final Scan<NodeCursor> allNodesScan() {
        this.ktx.assertOpen();
        return new NodeCursorScan(this.storageReader.allNodeScan(), this);
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(-1, this);
    }

    public final Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.ktx.assertOpen();
        return new RelationshipCursorScan(this.storageReader.allRelationshipScan(), this);
    }

    public final void relationshipTypeScan(int type, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(type, this);
    }

    public void relationshipGroups(long nodeReference, long reference, RelationshipGroupCursor cursor) {
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        switch (encoding) {
            case NONE: {
                ((DefaultRelationshipGroupCursor)cursor).init(nodeReference, reference, false, this);
                break;
            }
            case DENSE: {
                ((DefaultRelationshipGroupCursor)cursor).init(nodeReference, RelationshipReferenceEncoding.clearEncoding(reference), true, this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected encoding " + encoding);
            }
        }
    }

    public void relationships(long nodeReference, long reference, RelationshipTraversalCursor cursor) {
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        switch (encoding) {
            case NONE: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, false, this);
                break;
            }
            case DENSE: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, RelationshipReferenceEncoding.clearEncoding(reference), true, this);
                break;
            }
            case SELECTION: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, RelationshipReferenceEncoding.clearEncoding(reference), -1, null, false, this);
                break;
            }
            case DENSE_SELECTION: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, RelationshipReferenceEncoding.clearEncoding(reference), -1, null, true, this);
                break;
            }
            case NO_OUTGOING_OF_TYPE: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, -1L, (int)reference, RelationshipDirection.OUTGOING, true, this);
                break;
            }
            case NO_INCOMING_OF_TYPE: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, -1L, (int)reference, RelationshipDirection.INCOMING, true, this);
                break;
            }
            case NO_LOOPS_OF_TYPE: {
                ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, -1L, (int)reference, RelationshipDirection.LOOP, true, this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected encoding " + encoding);
            }
        }
    }

    public void nodeProperties(long nodeReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, this, (AssertOpen)this.ktx);
    }

    public void relationshipProperties(long relationshipReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, this, (AssertOpen)this.ktx);
    }

    public abstract IndexReader indexReader(IndexDescriptor var1, boolean var2) throws IndexNotFoundKernelException;

    abstract LabelScanReader labelScanReader();

    @Override
    public TransactionState txState() {
        return this.ktx.txState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.ktx.hasTxStateWithChanges();
    }

    public void acquireExclusiveNodeLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveLabelLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveLabelLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedNodeLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedRelationshipLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedLabelLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedLabelLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    <T extends SchemaDescriptorSupplier> T acquireSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), lockingKeys);
        return schemaLike;
    }

    <T extends SchemaDescriptorSupplier> void releaseSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.ktx.statementLocks().optimistic().releaseShared(schema.keyType(), lockingKeys);
    }

    void acquireSharedLock(ResourceType resource, long resourceId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), resource, resourceId);
    }

    private void acquireExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)types, ids);
    }

    private void releaseExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseExclusive((ResourceType)types, ids);
    }

    private void acquireSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), (ResourceType)types, ids);
    }

    private void releaseSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseShared((ResourceType)types, ids);
    }

    private void assertIndexOnline(IndexDescriptor index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.indexGetState(index) == InternalIndexState.ONLINE) {
            return;
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexDescriptor index, IndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.schema().getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    public void assertOpen() {
        this.ktx.assertOpen();
    }
}

