/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

class TimeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private volatile long lastCheckPointedTransactionId;
    private volatile Duration timeout;
    private volatile Stopwatch stopWatch;
    private final long timeMillisThreshold;
    private final SystemNanoClock clock;

    TimeCheckPointThreshold(long thresholdMillis, SystemNanoClock clock) {
        super("every " + TimeCheckPointThreshold.formatDuration(thresholdMillis) + " threshold");
        this.timeMillisThreshold = thresholdMillis;
        this.clock = clock;
        long randomStartOffset = thresholdMillis > 0L ? ThreadLocalRandom.current().nextLong(thresholdMillis) : 0L;
        this.timeout = Duration.ofMillis(thresholdMillis + randomStartOffset);
        this.stopWatch = clock.startStopWatch();
    }

    private static String formatDuration(long thresholdMillis) {
        return Format.duration((long)thresholdMillis, (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MILLISECONDS, unit -> " " + unit.name().toLowerCase());
    }

    @Override
    public void initialize(long transactionId) {
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId, long lastCommittedTransactionLogVersion) {
        return lastCommittedTransactionId > this.lastCheckPointedTransactionId && this.stopWatch.hasTimedOut(this.timeout);
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.lastCheckPointedTransactionId = transactionId;
        this.stopWatch = this.clock.startStopWatch();
        this.timeout = Duration.ofMillis(this.timeMillisThreshold);
    }

    @Override
    public long checkFrequencyMillis() {
        return this.timeMillisThreshold;
    }
}

