/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.impl.notification.NotificationDetail;

class NotificationDetailTest {
    NotificationDetailTest() {
    }

    @Test
    void shouldConstructIndexDetails() {
        NotificationDetail detail = NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"});
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted index"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"index on :Person(name)"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted index is: index on :Person(name)"));
    }

    @Test
    void shouldConstructSuboptimalIndexDetails() {
        NotificationDetail detail = NotificationDetail.Factory.suboptimalIndex((String)"Person", (String[])new String[]{"name"});
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"index"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"index on :Person(name)"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"index is: index on :Person(name)"));
    }

    @Test
    void shouldConstructCartesianProductDetailsSingular() {
        HashSet<String> idents = new HashSet<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"identifier"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"(n)"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"identifier is: (n)"));
    }

    @Test
    void shouldConstructCartesianProductDetails() {
        TreeSet<String> idents = new TreeSet<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"identifiers"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"(n, node2)"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"identifiers are: (n, node2)"));
    }

    @Test
    void shouldConstructJoinHintDetailsSingular() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifier"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"n"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifier is: n"));
    }

    @Test
    void shouldConstructJoinHintDetails() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        MatcherAssert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifiers"));
        MatcherAssert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"n, node2"));
        MatcherAssert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifiers are: n, node2"));
    }
}

