/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Value;

class IndexSettingUtilTest {
    IndexSettingUtilTest() {
    }

    @Test
    void shouldParseBoolean() {
        IndexSettingImpl setting = IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT;
        Class type = setting.getType();
        Assertions.assertEquals(Boolean.class, (Object)type);
        Boolean object = true;
        this.assertBoolean((IndexSetting)setting, object, true);
    }

    @Test
    void shouldParseString() {
        IndexSettingImpl setting = IndexSettingImpl.FULLTEXT_ANALYZER;
        Class type = setting.getType();
        Assertions.assertEquals(String.class, (Object)type);
        String object = "analyser";
        this.assertString((IndexSetting)setting, object, "analyser");
    }

    @Test
    void shouldParseDoubleArray() {
        IndexSettingImpl setting = IndexSettingImpl.SPATIAL_CARTESIAN_MAX;
        Class type = setting.getType();
        Assertions.assertEquals(double[].class, (Object)type);
        double[] expectedResult = new double[]{-45.0, -40.0};
        Object object = new byte[]{-45, -40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new short[]{-45, -40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new int[]{-45, -40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new long[]{-45L, -40L};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new float[]{-45.0f, -40.0f};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new double[]{-45.0, -40.0};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Byte[]{(byte)-45, (byte)-40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Short[]{(short)-45, (short)-40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Integer[]{-45, -40};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Long[]{-45L, -40L};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Float[]{Float.valueOf(-45.0f), Float.valueOf(-40.0f)};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Double[]{-45.0, -40.0};
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = new Number[]{(byte)1, (short)2, 3, 4L, Float.valueOf(5.0f), 6.0};
        this.assertDoubleArray((IndexSetting)setting, object, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        object = Arrays.asList((byte)-45, (byte)-40);
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList((short)-45, (short)-40);
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList(-45, -40);
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList(-45L, -40L);
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList(Float.valueOf(-45.0f), Float.valueOf(-40.0f));
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList(-45.0, -40.0);
        this.assertDoubleArray((IndexSetting)setting, object, expectedResult);
        object = Arrays.asList((byte)1, (short)2, 3, 4L, Float.valueOf(5.0f), 6.0);
        this.assertDoubleArray((IndexSetting)setting, object, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
    }

    @Test
    void shouldNotParseDoubleArray() {
        IndexSettingImpl setting = IndexSettingImpl.SPATIAL_CARTESIAN_MAX;
        Class type = setting.getType();
        Assertions.assertEquals(double[].class, (Object)type);
        Object object = new Byte[]{(byte)-45, null};
        Assertions.assertThrows(NullPointerException.class, () -> IndexSettingUtilTest.lambda$shouldNotParseDoubleArray$0((IndexSetting)setting, (Byte[])object));
        object = new String[]{"45", "40"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> IndexSettingUtilTest.lambda$shouldNotParseDoubleArray$1((IndexSetting)setting, (String[])object));
        object = Arrays.asList("45", "40");
        Assertions.assertThrows(IllegalArgumentException.class, () -> IndexSettingUtilTest.lambda$shouldNotParseDoubleArray$2((IndexSetting)setting, (List)object));
    }

    private void assertBoolean(IndexSetting setting, Object object, boolean expectedResult) {
        Value result = IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
        Assertions.assertTrue((boolean)(result instanceof BooleanValue));
        Assertions.assertEquals((Object)expectedResult, (Object)((BooleanValue)result).booleanValue());
    }

    private void assertString(IndexSetting setting, Object object, String expectedResult) {
        Value result = IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
        Assertions.assertTrue((boolean)(result instanceof StringValue));
        Assertions.assertEquals((Object)expectedResult, (Object)((StringValue)result).stringValue());
    }

    private void assertDoubleArray(IndexSetting setting, Object object, double[] expectedResult) {
        Value result = IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
        Assertions.assertTrue((boolean)(result instanceof DoubleArray));
        Assertions.assertArrayEquals((double[])expectedResult, (double[])((DoubleArray)result).asObjectCopy());
    }

    private static /* synthetic */ void lambda$shouldNotParseDoubleArray$2(IndexSetting setting, List object) throws Throwable {
        IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
    }

    private static /* synthetic */ void lambda$shouldNotParseDoubleArray$1(IndexSetting setting, String[] object) throws Throwable {
        IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
    }

    private static /* synthetic */ void lambda$shouldNotParseDoubleArray$0(IndexSetting setting, Byte[] object) throws Throwable {
        IndexSettingUtil.asIndexSettingValue((IndexSetting)setting, (Object)object);
    }
}

