/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Exceptions;

class ExceptionsTest {
    ExceptionsTest() {
    }

    @Test
    void shouldDetectContainsOneOfSome() {
        ARuntimeException cause = new ARuntimeException(new AnotherRuntimeException(new NullPointerException("Some words")));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)cause, (String)"words", (Class[])new Class[]{NullPointerException.class}));
        Assertions.assertFalse((boolean)Exceptions.contains((Throwable)cause, (String)"not", (Class[])new Class[]{NullPointerException.class}));
    }

    @Test
    void shouldSetMessage() {
        String initialMessage = "Initial message";
        LevelOneException exception = new LevelOneException(initialMessage);
        String prependedMessage = "Prepend this: " + exception.getMessage();
        Exceptions.withMessage((Throwable)exception, (String)prependedMessage);
        Assertions.assertEquals((Object)prependedMessage, (Object)exception.getMessage());
    }

    @Test
    void shouldChainExceptionsWhenInitialExceptionIsNull() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain(null, (Throwable)exception);
        Assertions.assertSame((Object)exception, (Object)chainedException);
    }

    @Test
    void shouldChainExceptionsWhenCurrentExceptionIsNull() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception, null);
        Assertions.assertSame((Object)exception, (Object)chainedException);
        MatcherAssert.assertThat((Object)chainedException.getSuppressed(), (Matcher)Matchers.emptyArray());
    }

    @Test
    void shouldChainExceptions() {
        RuntimeException exception1 = new RuntimeException();
        RuntimeException exception2 = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception1, (Throwable)exception2);
        Assertions.assertSame((Object)exception1, (Object)chainedException);
        MatcherAssert.assertThat((Object)chainedException.getSuppressed(), (Matcher)Matchers.arrayContaining((Object[])new Throwable[]{exception2}));
    }

    @Test
    void shouldNotChainSameException() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception, (Throwable)exception);
        Assertions.assertSame((Object)exception, (Object)chainedException);
        MatcherAssert.assertThat((Object)chainedException.getSuppressed(), (Matcher)Matchers.emptyArray());
    }

    private static class AnotherRuntimeException
    extends RuntimeException {
        AnotherRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class ARuntimeException
    extends RuntimeException {
        ARuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class LevelOneException
    extends Exception {
        LevelOneException(String message) {
            super(message);
        }
    }
}

