/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TestNodePropertyAccessor
implements NodePropertyAccessor {
    private final Map<Long, Map<Integer, Value>> nodePropertyMap = new HashMap<Long, Map<Integer, Value>>();

    TestNodePropertyAccessor(long nodeId, SchemaDescriptor schema, Value ... values) {
        this.addNode(nodeId, schema, values);
    }

    public void addNode(long nodeId, SchemaDescriptor schema, Value ... values) {
        HashMap<Integer, Value> propertyMap = new HashMap<Integer, Value>();
        int[] propertyIds = schema.getPropertyIds();
        for (int i = 0; i < propertyIds.length; ++i) {
            propertyMap.put(propertyIds[i], values[i]);
        }
        this.nodePropertyMap.put(nodeId, propertyMap);
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId) {
        if (this.nodePropertyMap.containsKey(nodeId)) {
            Value value = this.nodePropertyMap.get(nodeId).get(propertyKeyId);
            if (value == null) {
                return Values.NO_VALUE;
            }
            return value;
        }
        return Values.NO_VALUE;
    }
}

