/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;

class FieldSignatureTest {
    FieldSignatureTest() {
    }

    @Test
    void equalsShouldConsiderName() {
        Assertions.assertEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (String)"input without default");
        Assertions.assertNotEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (String)"input without default");
        Assertions.assertEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"hello")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"hello")), (String)"input with default");
        Assertions.assertNotEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"hello")), (Object)FieldSignature.inputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"hello")), (String)"input with default");
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (String)"output");
        Assertions.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (String)"output");
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (String)"deprecated output");
        Assertions.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (String)"deprecated output");
    }

    @Test
    void shouldTypeCheckDefaultValue() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (DefaultParameterValue)DefaultParameterValue.ntString((String)"bad")));
        Assertions.assertEquals((Object)exception.getMessage(), (Object)"Default value does not have a valid type, field type was INTEGER?, but value type was STRING?.");
    }

    @Test
    void equalsShouldConsiderType() {
        Assertions.assertEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (String)"input without default");
        Assertions.assertNotEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), (String)"input without default");
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (String)"output");
        Assertions.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (boolean)false), (String)"output");
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (String)"deprecated output");
        Assertions.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (boolean)true), (String)"deprecated output");
    }

    @Test
    void equalsShouldConsiderDefaultValue() {
        Assertions.assertEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"foo")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"foo")));
        Assertions.assertNotEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"bar")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.ntString((String)"baz")));
    }

    @Test
    void equalsShouldConsiderDeprecation() {
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true));
        Assertions.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
        Assertions.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
    }
}

