/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.common.TokenNameLookup;

public class SchemaTestUtil {
    public static final TokenNameLookup SIMPLE_NAME_LOOKUP = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return "Label" + labelId;
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return "RelType" + relationshipTypeId;
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return "property" + propertyKeyId;
        }
    };

    private SchemaTestUtil() {
    }

    public static void assertEquality(Object o1, Object o2) {
        Assert.assertEquals((String)(o1.getClass().getSimpleName() + "s are not equal"), (Object)o1, (Object)o2);
        Assert.assertEquals((String)(o1.getClass().getSimpleName() + "s do not have the same hashcode"), (long)o1.hashCode(), (long)o2.hashCode());
    }

    static void assertArray(int[] values, int ... expected) {
        MatcherAssert.assertThat((Object)values.length, (Matcher)Matchers.equalTo((Object)expected.length));
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((String)String.format("Expected %d, got %d at index %d", expected[i], values[i], i), (long)values[i], (long)expected[i]);
        }
    }
}

