/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.DiagnosticsReporter;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.kernel.diagnostics.NonInteractiveProgress;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class DiagnosticsReporterTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;

    DiagnosticsReporterTest() {
    }

    @Test
    void dumpFiles() throws Exception {
        DiagnosticsReporter reporter = this.setupDiagnosticsReporter();
        Path destination = this.testDirectory.file("logs.zip", new String[0]).toPath();
        reporter.dump(Collections.singleton("logs"), destination, (DiagnosticsReporterProgress)Mockito.mock(DiagnosticsReporterProgress.class), true);
        DiagnosticsReporterTest.verifyContent(destination);
    }

    @Test
    void shouldContinueAfterError() throws Exception {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        MyProvider myProvider = new MyProvider((FileSystemAbstraction)this.fileSystem);
        reporter.registerOfflineProvider((DiagnosticsOfflineReportProvider)myProvider);
        myProvider.addFile("logs/a.txt", this.createNewFileWithContent("a.txt", "file a"));
        Path destination = this.testDirectory.file("logs.zip", new String[0]).toPath();
        HashSet<String> classifiers = new HashSet<String>();
        classifiers.add("logs");
        classifiers.add("fail");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream out = new PrintStream(baos);
            NonInteractiveProgress progress = new NonInteractiveProgress(out, false);
            reporter.dump(classifiers, destination, (DiagnosticsReporterProgress)progress, true);
            MatcherAssert.assertThat((Object)baos.toString(), (Matcher)CoreMatchers.is((Object)String.format("1/2 fail.txt%n%nError: Failed to write fail.txt%n2/2 logs/a.txt%n....................  20%%%n....................  40%%%n....................  60%%%n....................  80%%%n.................... 100%%%n%n", new Object[0])));
        }
        URI uri = URI.create("jar:file:" + destination.toAbsolutePath().toUri().getRawPath());
        try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            List<String> fileA = Files.readAllLines(fs.getPath("logs/a.txt", new String[0]));
            Assertions.assertEquals((int)1, (int)fileA.size());
            Assertions.assertEquals((Object)"file a", (Object)fileA.get(0));
        }
    }

    @Test
    void supportPathsWithSpaces() throws IOException {
        DiagnosticsReporter reporter = this.setupDiagnosticsReporter();
        Path destination = this.testDirectory.file("log files.zip", new String[0]).toPath();
        reporter.dump(Collections.singleton("logs"), destination, (DiagnosticsReporterProgress)Mockito.mock(DiagnosticsReporterProgress.class), true);
        DiagnosticsReporterTest.verifyContent(destination);
    }

    private File createNewFileWithContent(String name, String content) throws IOException {
        Path file = this.testDirectory.file(name, new String[0]).toPath();
        Files.write(file, content.getBytes(), new OpenOption[0]);
        return file.toFile();
    }

    private DiagnosticsReporter setupDiagnosticsReporter() throws IOException {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        MyProvider myProvider = new MyProvider((FileSystemAbstraction)this.fileSystem);
        reporter.registerOfflineProvider((DiagnosticsOfflineReportProvider)myProvider);
        myProvider.addFile("logs/a.txt", this.createNewFileWithContent("a.txt", "file a"));
        myProvider.addFile("logs/b.txt", this.createNewFileWithContent("b.txt", "file b"));
        return reporter;
    }

    private static void verifyContent(Path destination) throws IOException {
        URI uri = URI.create("jar:file:" + destination.toAbsolutePath().toUri().getRawPath());
        try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            List<String> fileA = Files.readAllLines(fs.getPath("logs/a.txt", new String[0]));
            Assertions.assertEquals((int)1, (int)fileA.size());
            Assertions.assertEquals((Object)"file a", (Object)fileA.get(0));
            List<String> fileB = Files.readAllLines(fs.getPath("logs/b.txt", new String[0]));
            Assertions.assertEquals((int)1, (int)fileB.size());
            Assertions.assertEquals((Object)"file b", (Object)fileB.get(0));
        }
    }

    private static class FailingSource
    implements DiagnosticsReportSource {
        private FailingSource() {
        }

        public String destinationPath() {
            return "fail.txt";
        }

        public InputStream newInputStream() {
            throw new RuntimeException("You had it coming...");
        }

        public long estimatedSize() {
            return 0L;
        }
    }

    private static class MyProvider
    extends DiagnosticsOfflineReportProvider {
        private final FileSystemAbstraction fs;
        private final List<DiagnosticsReportSource> logFiles = new ArrayList<DiagnosticsReportSource>();

        MyProvider(FileSystemAbstraction fs) {
            super("my-provider", new String[]{"logs"});
            this.fs = fs;
        }

        void addFile(String destination, File file) {
            this.logFiles.add(DiagnosticsReportSources.newDiagnosticsFile((String)destination, (FileSystemAbstraction)this.fs, (File)file));
        }

        public void init(FileSystemAbstraction fs, String defaultDatabaseName, Config config, File storeDirectory) {
        }

        public List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
            ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
            if (classifiers.contains("fail")) {
                sources.add(new FailingSource());
            }
            if (classifiers.contains("logs")) {
                sources.addAll(this.logFiles);
            }
            return sources;
        }
    }
}

