/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;

class ConfigDiagnosticsTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final Log log = this.logProvider.getLog(ConfigDiagnostics.class);

    ConfigDiagnosticsTest() {
    }

    @Test
    void dumpConfigValues() {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.default_database, (Object)"testDb").set(GraphDatabaseSettings.max_concurrent_transactions, (Object)400).build();
        ConfigDiagnostics configDiagnostics = new ConfigDiagnostics(config);
        configDiagnostics.dump(arg_0 -> ((Log)this.log).info(arg_0));
        this.logProvider.formattedMessageMatcher().assertContains("DBMS provided settings:");
        this.logProvider.formattedMessageMatcher().assertContains(GraphDatabaseSettings.max_concurrent_transactions.name() + "=400");
        this.logProvider.formattedMessageMatcher().assertContains(GraphDatabaseSettings.default_database.name() + "=testDb");
        this.logProvider.formattedMessageMatcher().assertNotContains("No provided DBMS settings.");
    }

    @Test
    void dumpDefaultConfig() {
        Config config = Config.defaults();
        ConfigDiagnostics configDiagnostics = new ConfigDiagnostics(config);
        configDiagnostics.dump(arg_0 -> ((Log)this.log).info(arg_0));
        this.logProvider.formattedMessageMatcher().assertContains("No provided DBMS settings.");
        this.logProvider.formattedMessageMatcher().assertNotContains("DBMS provided settings");
    }
}

