/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.lock.LockTracer;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;

class KernelStatementTest {
    KernelStatementTest() {
    }

    @Test
    void shouldReleaseResourcesWhenForceClosed() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.isSuccess()).thenReturn((Object)true);
        KernelStatement statement = KernelStatementTest.createStatement(transaction);
        statement.acquire();
        Assertions.assertThrows(KernelStatement.StatementNotClosedException.class, () -> ((KernelStatement)statement).forceClose());
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatementResources();
    }

    @Test
    void assertStatementIsNotOpenWhileAcquireIsNotInvoked() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelStatement statement = KernelStatementTest.createStatement(transaction);
        Assertions.assertThrows(NotInTransactionException.class, () -> ((KernelStatement)statement).assertOpen());
    }

    @Test
    void reportQueryWaitingTimeToTransactionStatisticWhenFinishQueryExecution() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelTransactionImplementation.Statistics statistics = new KernelTransactionImplementation.Statistics(transaction, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE));
        Mockito.when((Object)transaction.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)transaction.executingQuery()).thenReturn(Optional.empty());
        KernelStatement statement = KernelStatementTest.createStatement(transaction);
        statement.acquire();
        ExecutingQuery query = KernelStatementTest.getQueryWithWaitingTime();
        ExecutingQuery query2 = KernelStatementTest.getQueryWithWaitingTime();
        ExecutingQuery query3 = KernelStatementTest.getQueryWithWaitingTime();
        statement.stopQueryExecution(query);
        statement.stopQueryExecution(query2);
        statement.stopQueryExecution(query3);
        Assertions.assertEquals((long)3L, (long)statistics.getWaitingTimeNanos(1L));
    }

    private static KernelStatement createStatement(KernelTransactionImplementation transaction) {
        return new KernelStatement(transaction, LockTracer.NONE, new ClockContext(), EmptyVersionContextSupplier.EMPTY, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new TestDatabaseIdRepository().defaultDatabase());
    }

    private static ExecutingQuery getQueryWithWaitingTime() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.reportedWaitingTimeNanos()).thenReturn((Object)1L);
        return executingQuery;
    }
}

