/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.lock.LockTracer;
import org.neo4j.resources.CpuClock;

class StatementLifecycleTest {
    StatementLifecycleTest() {
    }

    @Test
    void shouldReleaseStoreStatementOnlyWhenReferenceCountDownToZero() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelStatement statement = StatementLifecycleTest.createStatement(transaction);
        statement.acquire();
        statement.acquire();
        statement.close();
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).releaseStatementResources();
        statement.close();
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatementResources();
    }

    @Test
    void shouldReleaseStoreStatementWhenForceClosingStatements() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.isSuccess()).thenReturn((Object)true);
        KernelStatement statement = StatementLifecycleTest.createStatement(transaction);
        statement.acquire();
        Assertions.assertThrows(KernelStatement.StatementNotClosedException.class, () -> ((KernelStatement)statement).forceClose());
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatementResources();
    }

    private static KernelStatement createStatement(KernelTransactionImplementation transaction) {
        return new KernelStatement(transaction, LockTracer.NONE, new ClockContext(), EmptyVersionContextSupplier.EMPTY, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new TestDatabaseIdRepository().defaultDatabase());
    }
}

