/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;

class IndexPopulationJobControllerTest {
    private final OnDemandJobScheduler executer = new OnDemandJobScheduler();
    private final IndexPopulationJobController jobController = new IndexPopulationJobController((JobScheduler)this.executer);

    IndexPopulationJobControllerTest() {
    }

    @Test
    void trackPopulationJobs() {
        MatcherAssert.assertThat((Object)this.jobController.getPopulationJobs(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        IndexPopulationJob populationJob = (IndexPopulationJob)Mockito.mock(IndexPopulationJob.class);
        this.jobController.startIndexPopulation(populationJob);
        MatcherAssert.assertThat((Object)this.jobController.getPopulationJobs(), (Matcher)Matchers.hasSize((int)1));
        IndexPopulationJob populationJob2 = (IndexPopulationJob)Mockito.mock(IndexPopulationJob.class);
        this.jobController.startIndexPopulation(populationJob2);
        MatcherAssert.assertThat((Object)this.jobController.getPopulationJobs(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    void stopOngoingPopulationJobs() throws InterruptedException {
        IndexPopulationJob populationJob = this.getIndexPopulationJob();
        IndexPopulationJob populationJob2 = this.getIndexPopulationJob();
        this.jobController.startIndexPopulation(populationJob);
        this.jobController.startIndexPopulation(populationJob2);
        this.jobController.stop();
        ((IndexPopulationJob)Mockito.verify((Object)populationJob)).cancel();
        ((IndexPopulationJob)Mockito.verify((Object)populationJob2)).cancel();
    }

    @Test
    void untrackFinishedPopulations() {
        IndexPopulationJob populationJob = this.getIndexPopulationJob();
        this.jobController.startIndexPopulation(populationJob);
        MatcherAssert.assertThat((Object)this.jobController.getPopulationJobs(), (Matcher)Matchers.hasSize((int)1));
        this.executer.runJob();
        MatcherAssert.assertThat((Object)this.jobController.getPopulationJobs(), (Matcher)Matchers.hasSize((int)0));
        ((IndexPopulationJob)Mockito.verify((Object)populationJob)).run();
    }

    private IndexPopulationJob getIndexPopulationJob() {
        return (IndexPopulationJob)Mockito.mock(IndexPopulationJob.class);
    }
}

