/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDropper;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class IndexingServiceTest {
    private final LifeSupport life = new LifeSupport();
    private static final AssertableLogProvider.LogMatcherBuilder logMatch = AssertableLogProvider.inLog(IndexingService.class);
    private static final IndexProviderDescriptor native30Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE30.providerVersion());
    private static final IndexProviderDescriptor nativeBtree10Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    private static final IndexProviderDescriptor fulltextDescriptor = new IndexProviderDescriptor("fulltext", "1.0");
    private static final IndexProviderDescriptor[] indexProviderDescriptors = new IndexProviderDescriptor[]{native30Descriptor, nativeBtree10Descriptor, fulltextDescriptor};
    private final SchemaState schemaState = (SchemaState)Mockito.mock(SchemaState.class);
    private final int labelId = 7;
    private final int propertyKeyId = 15;
    private final int uniquePropertyKeyId = 15;
    private final IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)7, (int[])new int[]{15})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index");
    private final IndexDescriptor index = this.prototype.materialise(0L);
    private final IndexPrototype uniqueIndex = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)7, (int[])new int[]{15})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("constraint");
    private final IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class, (Answer)Mockito.RETURNS_MOCKS);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final NodePropertyAccessor propertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    private final InMemoryNameLookup nameLookup = new InMemoryNameLookup();
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
    private final JobScheduler scheduler = JobSchedulerFactory.createScheduler();

    IndexingServiceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenAnswer(invocation -> invocation.getArgument(1));
        Mockito.when((Object)this.indexStatisticsStore.indexUpdatesAndSize(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenAnswer(invocation -> invocation.getArgument(1));
        Mockito.when((Object)this.storeView.newPropertyAccessor()).thenReturn((Object)this.propertyAccessor);
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
    }

    @Test
    void noMessagesWhenThereIsNoIndexes() throws Throwable {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.start();
        this.internalLogProvider.assertNoLoggingOccurred();
    }

    @Test
    void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new IndexDescriptor[]{this.index});
        IndexProxy proxy = indexingService.getIndexProxy(this.index);
        this.waitForIndexesToComeOnline(indexingService, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE_IDEMPOTENT);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new IndexDescriptor[]{this.index});
        indexingService.createIndexes(new IndexDescriptor[]{this.index});
        this.waitForIndexesToComeOnline(indexingService, this.index);
    }

    @Test
    void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater(this.propertyAccessor)).thenReturn((Object)this.updater);
        final CountDownLatch populationLatch = new CountDownLatch(1);
        final Barrier.Control populationStartBarrier = new Barrier.Control();
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                populationStartBarrier.reached();
            }

            public void indexPopulationScanComplete() {
                try {
                    populationLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Index population monitor was interrupted", e);
                }
            }
        };
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(1L, "value1")), (IndexingService.Monitor)monitor, new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(new IndexDescriptor[]{this.index});
        IndexProxy proxy = indexingService.getIndexProxy(this.index);
        Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        populationStartBarrier.await();
        populationStartBarrier.release();
        IndexEntryUpdate<IndexDescriptor> value2 = this.add(2L, "value2");
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(value2);
        }
        populationLatch.countDown();
        this.waitForIndexesToComeOnline(indexingService, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).close(true);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).includeSample(this.add(1L, "value1"));
        ((IndexPopulator)order.verify((Object)this.populator, Mockito.times((int)1))).add((Collection)ArgumentMatchers.any(Collection.class));
        ((IndexPopulator)order.verify((Object)this.populator)).scanCompleted((PhaseTracker)ArgumentMatchers.any(PhaseTracker.class));
        ((IndexPopulator)order.verify((Object)this.populator, Mockito.times((int)2))).add((Collection)ArgumentMatchers.any(Collection.class));
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater(this.propertyAccessor);
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).sampleResult();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)this.accessor.newReader()).thenReturn((Object)indexReader);
        ((IndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.index, new long[0])).when((Object)indexReader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexOrder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexQuery[])ArgumentMatchers.any());
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index = IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexingService.createIndexes(new IndexDescriptor[]{index});
        IndexProxy proxy = indexingService.getIndexProxy(index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)20000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index = IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexingService.createIndexes(new IndexDescriptor[]{index});
        IndexProxy proxy = indexingService.getIndexProxy(index);
        indexingService.activateIndex(index);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
    }

    @Test
    void shouldLogIndexStateOnInit() throws Exception {
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider, IndexingServiceTest.fulltextProvider()), config));
        IndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)this.nameLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false));
        Mockito.when((Object)provider.getInitialState(onlineIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        this.nameLookup.label(1, "LabelOne");
        this.nameLookup.label(2, "LabelTwo");
        this.nameLookup.property(1, "propertyOne");
        this.nameLookup.property(2, "propertyTwo");
        this.life.init();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.debug("IndexingService.init: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.debug("IndexingService.init: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.debug("IndexingService.init: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    void shouldLogIndexStateOnStart() throws Throwable {
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider, IndexingServiceTest.fulltextProvider()), config);
        providerMap.init();
        IndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false);
        Mockito.when((Object)provider.getInitialState(onlineIndex)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.init();
        this.nameLookup.label(1, "LabelOne");
        this.nameLookup.label(2, "LabelTwo");
        this.nameLookup.property(1, "propertyOne");
        this.nameLookup.property(2, "propertyTwo");
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.internalLogProvider.clear();
        indexingService.start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulationFailure(failedIndex);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.debug("IndexingService.start: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.debug("IndexingService.start: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.debug("IndexingService.start: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    void shouldLogDeprecatedIndexesOnStart() throws Exception {
        int id = 1;
        ArrayList<IndexDescriptor> indexDescriptors = new ArrayList<IndexDescriptor>();
        IndexProvider[] indexProviders = new IndexProvider[indexProviderDescriptors.length];
        for (int i = 0; i < indexProviderDescriptors.length; ++i) {
            IndexProvider indexProvider;
            IndexProviderDescriptor indexProviderDescriptor = indexProviderDescriptors[i];
            indexProviders[i] = indexProvider = IndexingServiceTest.mockIndexProviderWithAccessor(indexProviderDescriptor);
            for (int j = 0; j < 2; ++j) {
                IndexDescriptor index = IndexingServiceTest.storeIndex(id, 1, id, indexProviderDescriptor);
                indexDescriptors.add(index);
                Mockito.when((Object)indexProvider.getInitialState(index)).thenReturn((Object)InternalIndexState.ONLINE);
                ++id;
            }
        }
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)nativeBtree10Descriptor.name());
        DependencyResolver dependencies = IndexingServiceTest.buildIndexDependencies(indexProviders);
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(dependencies, config);
        providerMap.init();
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, indexDescriptors, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false);
        indexingService.init();
        for (IndexProviderDescriptor indexProviderDescriptor : indexProviderDescriptors) {
            this.onBothLogProviders(logProvider -> logProvider.rawMessageMatcher().assertNotContains(indexProviderDescriptor.name()));
        }
        this.userLogProvider.clear();
        indexingService.start();
        for (IndexProviderDescriptor indexProviderDescriptor : indexProviderDescriptors) {
            if (this.isDeprecated(indexProviderDescriptor)) {
                this.userLogProvider.rawMessageMatcher().assertContainsSingle(Matchers.allOf((Matcher)Matchers.containsString((String)"Deprecated index providers in use:"), (Matcher)Matchers.containsString((String)(indexProviderDescriptor.name() + " (2 indexes)")), (Matcher)Matchers.containsString((String)"Use procedure 'db.indexes()' to see what indexes use which index provider.")));
                continue;
            }
            this.onBothLogProviders(logProvider -> logProvider.rawMessageMatcher().assertNotContains(indexProviderDescriptor.name()));
        }
    }

    private boolean isDeprecated(IndexProviderDescriptor indexProviderDescriptor) {
        for (GraphDatabaseSettings.SchemaIndex schemaIndex : GraphDatabaseSettings.SchemaIndex.values()) {
            if (!schemaIndex.providerName().equals(indexProviderDescriptor.name())) continue;
            return schemaIndex.deprecated();
        }
        return false;
    }

    @Test
    void shouldFailToStartIfMissingIndexProvider() throws Exception {
        String otherProviderKey = "something-completely-different";
        IndexProviderDescriptor otherDescriptor = new IndexProviderDescriptor(otherProviderKey, "no-version");
        IndexDescriptor rule = IndexingServiceTest.storeIndex(1L, 2, 3, otherDescriptor);
        this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(), rule);
        LifecycleException e = (LifecycleException)Assertions.assertThrows(LifecycleException.class, () -> ((LifeSupport)this.life).init());
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name()));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)otherProviderKey));
    }

    @Test
    void shouldSnapshotOnlineIndexes() throws Exception {
        int indexId = 1;
        int indexId2 = 2;
        IndexDescriptor rule1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor rule2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(), rule1, rule2);
        File theFile = new File("Blah");
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState(rule1)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState(rule2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        MatcherAssert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object[])new File[]{theFile, theFile}))));
    }

    @Test
    void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        int indexId = 1;
        int indexId2 = 2;
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(), index1, index2);
        File theFile = new File("Blah");
        ((IndexPopulator)Mockito.doAnswer(IndexingServiceTest.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState(index1)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState(index2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        populatorLatch.countDown();
        this.waitForIndexesToComeOnline(indexing, index1, index2);
        MatcherAssert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)theFile))));
    }

    @Test
    void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index").materialise(0L);
        indexingService.activateIndex(index);
    }

    @Test
    void shouldLogTriggerSamplingOnAllIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        IndexSamplingMode mode = IndexSamplingMode.backgroundRebuildAll();
        indexingService.triggerIndexSampling(mode);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling all indexes [" + mode + "]")});
    }

    @Test
    void shouldLogTriggerSamplingOnAnIndexes() throws Exception {
        long indexId = 0L;
        IndexSamplingMode mode = IndexSamplingMode.backgroundRebuildAll();
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index");
        IndexDescriptor index = prototype.materialise(indexId);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), index);
        this.life.init();
        this.life.start();
        indexingService.triggerIndexSampling(index, mode);
        String userDescription = index.userDescription((TokenNameLookup)this.nameLookup);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling index " + userDescription + " [" + mode + "]")});
    }

    @Test
    void applicationOfIndexUpdatesShouldThrowIfServiceIsShutdown() throws IOException {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        this.life.shutdown();
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> indexingService.applyUpdates((Iterable)Iterators.asSet((Object[])new IndexEntryUpdate[]{this.add(1L, "foo")})));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Can't apply index updates"));
    }

    @Test
    void applicationOfUpdatesShouldFlush() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        this.life.start();
        indexing.createIndexes(new IndexDescriptor[]{this.index});
        this.waitForIndexesToComeOnline(indexing, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(true);
        indexing.applyUpdates(Arrays.asList(this.add(1L, "foo"), this.add(2L, "bar")));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.updater});
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(1L, "foo"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(2L, "bar"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void closingOfValidatedUpdatesShouldCloseUpdaters() throws Exception {
        long indexId1 = 1L;
        long indexId2 = 2L;
        int labelId1 = 24;
        int labelId2 = 42;
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(indexId1, labelId1, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(indexId2, labelId2, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        IndexAccessor accessor1 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor1.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater1);
        IndexAccessor accessor2 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor2.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater2);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)index1), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor1);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)index2), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor2);
        this.life.start();
        indexing.createIndexes(new IndexDescriptor[]{index1});
        indexing.createIndexes(new IndexDescriptor[]{index2});
        this.waitForIndexesToComeOnline(indexing, index1, index2);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(true);
        indexing.applyUpdates(Arrays.asList(this.add(1L, "foo", index1), this.add(2L, "bar", index2)));
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
    }

    private void waitForIndexesToComeOnline(IndexingService indexing, IndexDescriptor ... index) throws IndexNotFoundKernelException {
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.ONLINE, index);
    }

    private void waitForIndexesToGetIntoState(IndexingService indexing, InternalIndexState state, IndexDescriptor ... indexes) throws IndexNotFoundKernelException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (!this.allInState(indexing, state, indexes)) {
            if (System.currentTimeMillis() <= end) continue;
            Assertions.fail((String)"Indexes couldn't come online");
        }
    }

    private boolean allInState(IndexingService indexing, InternalIndexState state, IndexDescriptor[] indexes) throws IndexNotFoundKernelException {
        for (IndexDescriptor index : indexes) {
            if (indexing.getIndexProxy(index).getState() == state) continue;
            return false;
        }
        return true;
    }

    private Iterable<IndexEntryUpdate<IndexDescriptor>> nodeIdsAsIndexUpdates(long ... nodeIds) {
        return () -> {
            ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>();
            for (long nodeId : nodeIds) {
                updates.add(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{Values.of((Object)1)}));
            }
            return updates.iterator();
        };
    }

    @Test
    void shouldNotLoseIndexDescriptorDueToOtherSimilarIndexDuringRecovery() throws Exception {
        long nodeId = 0L;
        long otherIndexId = 2L;
        EntityUpdates update = this.addNodeUpdate(nodeId, "value");
        Register.DoubleLongRegister register = (Register.DoubleLongRegister)Mockito.mock(Register.DoubleLongRegister.class);
        Mockito.when((Object)register.readSecond()).thenReturn((Object)42L);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)register);
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)((Object)new TrackingIndexAccessor()));
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, IndexingServiceTest.withData(update), this.index);
        Mockito.when((Object)this.indexProvider.getInitialState(this.index)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        IndexDescriptor otherIndex = this.prototype.withName("index_" + otherIndexId).materialise(otherIndexId);
        indexing.createIndexes(new IndexDescriptor[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.createIndexes(new IndexDescriptor[]{this.index});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        indexing.applyUpdates(this.nodeIdsAsIndexUpdates(nodeId));
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor)).newUpdater(IndexUpdateMode.RECOVERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotLoseIndexDescriptorDueToOtherVerySimilarIndexDuringRecovery() throws Exception {
        AtomicReference<BinaryLatch> populationStartLatch = this.latchedIndexPopulation();
        long nodeId = 0L;
        EntityUpdates update = this.addNodeUpdate(nodeId, "value");
        Register.DoubleLongRegister register = (Register.DoubleLongRegister)Mockito.mock(Register.DoubleLongRegister.class);
        Mockito.when((Object)register.readSecond()).thenReturn((Object)42L);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)register);
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)((Object)new TrackingIndexAccessor()));
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, IndexingServiceTest.withData(update), this.index);
        Mockito.when((Object)this.indexProvider.getInitialState(this.index)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        populationStartLatch.getAndSet(new BinaryLatch()).release();
        IndexConfig indexConfig = this.index.getIndexConfig().withIfAbsent("a", (Value)Values.booleanValue((boolean)true));
        IndexDescriptor otherIndex = this.index.withIndexConfig(indexConfig);
        indexing.createIndexes(new IndexDescriptor[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.createIndexes(new IndexDescriptor[]{this.index});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        indexing.applyUpdates(this.nodeIdsAsIndexUpdates(nodeId));
        this.life.start();
        IndexProxy indexProxy = indexing.getIndexProxy(this.index);
        try {
            Assertions.assertNull((Object)indexProxy.getDescriptor().getIndexConfig().get("a"));
            MatcherAssert.assertThat((Object)indexProxy.getState(), (Matcher)Matchers.is((Object)InternalIndexState.POPULATING));
        }
        finally {
            populationStartLatch.get().release();
        }
    }

    @Test
    void shouldWaitForRecoveredUniquenessConstraintIndexesToBeFullyPopulated() throws Exception {
        final DoubleLatch latch = new DoubleLatch();
        ControlledIndexPopulator populator = new ControlledIndexPopulator(latch);
        final AtomicReference indexRef = new AtomicReference();
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(IndexDescriptor descriptor) {
                indexRef.set(descriptor);
                latch.startAndWaitForAllToStart();
            }
        };
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), (IndexingService.Monitor)monitor, new IndexDescriptor[0]);
        this.life.init();
        long fakeOwningConstraintRuleId = 1L;
        indexing.createIndexes(new IndexDescriptor[]{IndexingServiceTest.constraintIndexRule(2L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, fakeOwningConstraintRuleId)});
        this.life.start();
        Assertions.assertEquals((long)2L, (long)((IndexDescriptor)indexRef.get()).getId());
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexing.getIndexProxy((IndexDescriptor)indexRef.get()).getState());
    }

    @Test
    void shouldCreateMultipleIndexesInOneCall() throws Exception {
        IndexingService.Monitor monitor = IndexingService.NO_MONITOR;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), monitor, new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(0L, 0, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(1L, 0, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index3 = IndexingServiceTest.storeIndex(2L, 1, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexing.createIndexes(new IndexDescriptor[]{index1, index2, index3});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withName("index_0").materialise(0L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withSchemaDescriptor((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})).withName("index_1").materialise(1L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withSchemaDescriptor((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{0})).withName("index_2").materialise(2L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        this.waitForIndexesToComeOnline(indexing, index1, index2, index3);
    }

    @Test
    void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterPopulating() throws Exception {
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), new IndexDescriptor[0]);
        IOException exception = new IOException("Expected failure");
        this.nameLookup.label(7, "TheLabel");
        this.nameLookup.property(15, "propertyKey");
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        indexing.createIndexes(new IndexDescriptor[]{this.index});
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(this.index).getState());
        Assertions.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        MatcherAssert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.internalLogProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    @Test
    void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterRecoveringPopulatingIndex() throws Exception {
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), this.index);
        IOException exception = new IOException("Expected failure");
        this.nameLookup.label(7, "TheLabel");
        this.nameLookup.property(15, "propertyKey");
        Mockito.when((Object)this.indexProvider.getInitialState(this.index)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        this.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(this.index).getState());
        Assertions.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        MatcherAssert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.internalLogProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void constraintIndexesWithoutConstraintsMustGetPopulatingProxies() throws Exception {
        AtomicReference<BinaryLatch> populationStartLatch = this.latchedIndexPopulation();
        try {
            long indexId = 1L;
            IndexDescriptor index = this.uniqueIndex.materialise(indexId);
            IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), index);
            Mockito.when((Object)this.indexProvider.getInitialState(index)).thenReturn((Object)InternalIndexState.POPULATING);
            this.life.start();
            Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)indexing.getIndexProxy(index).getState());
        }
        finally {
            populationStartLatch.get().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    void shouldReportCauseOfPopulationFailureIfPopulationFailsDuringRecovery() throws Exception {
        long indexId = 1L;
        long constraintId = 2L;
        IndexDescriptor indexRule = this.uniqueIndex.materialise(indexId).withOwningConstraintId(constraintId);
        final Barrier.Control barrier = new Barrier.Control();
        CountDownLatch exceptionBarrier = new CountDownLatch(1);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), (IndexingService.Monitor)new IndexingService.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(IndexDescriptor descriptor) {
                barrier.reached();
            }
        }, indexRule);
        Mockito.when((Object)this.indexProvider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.POPULATING);
        this.life.init();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(() -> {
                try {
                    this.life.start();
                }
                finally {
                    exceptionBarrier.countDown();
                }
            });
            barrier.await();
            this.waitForIndexesToComeOnline(indexing, indexRule);
            IndexProxy indexProxy = indexing.getIndexProxy(indexRule);
            MatcherAssert.assertThat((Object)indexProxy, (Matcher)Matchers.instanceOf(ContractCheckingIndexProxy.class));
            ContractCheckingIndexProxy contractCheckingIndexProxy = (ContractCheckingIndexProxy)indexProxy;
            IndexProxy delegate = contractCheckingIndexProxy.getDelegate();
            MatcherAssert.assertThat((Object)delegate, (Matcher)Matchers.instanceOf(FlippableIndexProxy.class));
            FlippableIndexProxy flippableIndexProxy = (FlippableIndexProxy)delegate;
            Exception expectedCause = new Exception("index was failed on purpose");
            IndexPopulationFailure indexFailure = IndexPopulationFailure.failure((Throwable)expectedCause);
            flippableIndexProxy.flipTo((IndexProxy)new FailedIndexProxy(indexRule, "string", (IndexDropper)Mockito.mock(IndexPopulator.class), indexFailure, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (LogProvider)this.internalLogProvider));
            barrier.release();
            exceptionBarrier.await();
            this.internalLogProvider.rawMessageMatcher().assertContains(expectedCause.getMessage());
            this.internalLogProvider.rawMessageMatcher().assertContains(String.format("Index %s entered %s state ", indexRule.toString(), InternalIndexState.FAILED));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldLogIndexStateOutliersOnInit() throws Exception {
        int i;
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider, IndexingServiceTest.fulltextProvider()), config));
        ArrayList<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>();
        int nextIndexId = 1;
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            IndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            this.nameLookup.label(i, "Label" + i);
        }
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)this.nameLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false));
        this.nameLookup.property(1, "prop");
        this.life.init();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.init: index 1 on :Label1(prop) is POPULATING"), logMatch.info("IndexingService.init: index 2 on :Label2(prop) is FAILED"), logMatch.info("IndexingService.init: indexes not specifically mentioned above are ONLINE")});
        this.internalLogProvider.assertNone(logMatch.info("IndexingService.init: index 3 on :Label3(prop) is ONLINE"));
    }

    @Test
    void shouldLogIndexStateOutliersOnStart() throws Throwable {
        int i;
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        DefaultIndexProviderMap providerMap = new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(provider, IndexingServiceTest.fulltextProvider()), config);
        providerMap.init();
        ArrayList<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>();
        int nextIndexId = 1;
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(populatingIndex)).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(failedIndex)).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            IndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState(indexRule)).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            this.nameLookup.label(i, "Label" + i);
        }
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong(), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.nameLookup.property(1, "prop");
        indexingService.init();
        this.internalLogProvider.clear();
        indexingService.start();
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.start: index 1 on :Label1(prop) is POPULATING"), logMatch.info("IndexingService.start: index 2 on :Label2(prop) is FAILED"), logMatch.info("IndexingService.start: indexes not specifically mentioned above are ONLINE")});
        this.internalLogProvider.assertNone(logMatch.info("IndexingService.start: index 3 on :Label3(prop) is ONLINE"));
    }

    @Test
    void flushAllIndexesWhileSomeOfThemDropped() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy validIndex1 = IndexingServiceTest.createIndexProxyMock(1L);
        IndexProxy validIndex2 = IndexingServiceTest.createIndexProxyMock(2L);
        IndexProxy deletedIndexProxy = IndexingServiceTest.createIndexProxyMock(3L);
        IndexProxy validIndex3 = IndexingServiceTest.createIndexProxyMock(4L);
        IndexProxy validIndex4 = IndexingServiceTest.createIndexProxyMock(5L);
        indexMapReference.modify(indexMap -> {
            indexMap.putIndexProxy(validIndex1);
            indexMap.putIndexProxy(validIndex2);
            indexMap.putIndexProxy(deletedIndexProxy);
            indexMap.putIndexProxy(validIndex3);
            indexMap.putIndexProxy(validIndex4);
            return indexMap;
        });
        ((IndexProxy)Mockito.doAnswer(invocation -> {
            indexMapReference.modify(indexMap -> {
                indexMap.removeIndexProxy(3L);
                return indexMap;
            });
            throw new RuntimeException("Index deleted.");
        }).when((Object)deletedIndexProxy)).force((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.forceAll(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex1)).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex2)).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex3)).force(IOLimiter.UNLIMITED);
        ((IndexProxy)Mockito.verify((Object)validIndex4)).force(IOLimiter.UNLIMITED);
    }

    @Test
    void failForceAllWhenOneOfTheIndexesFailToForce() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy strangeIndexProxy = IndexingServiceTest.createIndexProxyMock(1L);
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(new IOException("Can't force"))}).when((Object)strangeIndexProxy)).force((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        indexMapReference.modify(indexMap -> {
            IndexProxy validIndex = IndexingServiceTest.createIndexProxyMock(0L);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(strangeIndexProxy);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            return indexMap;
        });
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        UnderlyingStorageException e = (UnderlyingStorageException)Assertions.assertThrows(UnderlyingStorageException.class, () -> indexingService.forceAll(IOLimiter.UNLIMITED));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to force"));
    }

    @Test
    void shouldRefreshIndexesOnStart() throws Exception {
        this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), this.index);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)updater);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        this.life.init();
        ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.never())).refresh();
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor)).refresh();
    }

    @Test
    void shouldNotHaveToWaitForOrphanedUniquenessIndexInRecovery() throws Exception {
        IndexDescriptor descriptor = this.uniqueIndex.materialise(10L);
        List<IndexDescriptor> schemaRules = Collections.singletonList(descriptor);
        IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        IndexProviderMap indexProviderMap = (IndexProviderMap)Mockito.mock(IndexProviderMap.class);
        Mockito.when((Object)indexProviderMap.lookup(ArgumentMatchers.anyString())).thenReturn((Object)indexProvider);
        Mockito.when((Object)indexProviderMap.lookup((IndexProviderDescriptor)ArgumentMatchers.any(IndexProviderDescriptor.class))).thenReturn((Object)indexProvider);
        Mockito.when((Object)indexProviderMap.getDefaultProvider()).thenReturn((Object)indexProvider);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxyCreator indexProxyCreator = (IndexProxyCreator)Mockito.mock(IndexProxyCreator.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING, (Object[])new InternalIndexState[]{InternalIndexState.POPULATING, InternalIndexState.POPULATING, InternalIndexState.POPULATING, InternalIndexState.ONLINE});
        Mockito.when((Object)indexProxyCreator.createRecoveringIndexProxy((IndexDescriptor)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxyCreator.createFailedIndexProxy((IndexDescriptor)ArgumentMatchers.any(), (IndexPopulationFailure)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxyCreator.createPopulatingIndexProxy((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexingService.Monitor)ArgumentMatchers.any(), (IndexPopulationJob)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        MultiPopulatorFactory multiPopulatorFactory = MultiPopulatorFactory.forConfig((Config)Config.defaults((Setting)GraphDatabaseSettings.multi_threaded_schema_index_population_enabled, (Object)false));
        JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        IndexSamplingController samplingController = (IndexSamplingController)Mockito.mock(IndexSamplingController.class);
        IndexingService.Monitor monitor = (IndexingService.Monitor)Mockito.mock(IndexingService.Monitor.class);
        IndexingService indexingService = new IndexingService(indexProxyCreator, indexProviderMap, indexMapReference, (IndexStoreView)Mockito.mock(IndexStoreView.class), schemaRules, samplingController, TokenNameLookup.idTokenNameLookup, scheduler, null, multiPopulatorFactory, (LogProvider)logProvider, (LogProvider)logProvider, monitor, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), false);
        indexingService.init();
        indexingService.start();
        ((IndexProxy)Mockito.verify((Object)indexProxy, (VerificationMode)Mockito.never())).awaitStoreScanCompleted(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((IndexingService.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).awaitingPopulationOfRecoveredIndex((IndexDescriptor)ArgumentMatchers.any());
    }

    @Test
    public void shouldIncrementIndexUpdatesAfterStartingExistingOnlineIndexProxy() throws Exception {
        long indexId = 10L;
        IndexDescriptor indexDescriptor = this.uniqueIndex.materialise(indexId);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), indexDescriptor);
        this.life.start();
        IndexProxy proxy = indexingService.getIndexProxy(indexDescriptor);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(IndexEntryUpdate.add((long)123L, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"some value")}));
        }
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).incrementIndexUpdates(indexId, 1L);
    }

    @Test
    public void shouldDropAndCreateIndexWithSameIdDuringRecovery() throws IOException {
        long indexId = 10L;
        IndexDescriptor indexDescriptor = this.uniqueIndex.materialise(indexId);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new EntityUpdates[0]), indexDescriptor);
        this.life.init();
        indexingService.dropIndex(indexDescriptor);
        indexingService.createIndexes(new IndexDescriptor[]{indexDescriptor});
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
    }

    private AtomicReference<BinaryLatch> latchedIndexPopulation() {
        final AtomicReference<BinaryLatch> populationStartLatch = new AtomicReference<BinaryLatch>(new BinaryLatch());
        this.scheduler.setThreadFactory(Group.INDEX_POPULATION, (group, parent) -> new GroupedDaemonThreadFactory(group, parent){

            public Thread newThread(Runnable job) {
                return super.newThread(() -> {
                    ((BinaryLatch)populationStartLatch.get()).await();
                    job.run();
                });
            }
        });
        return populationStartLatch;
    }

    private static IndexProxy createIndexProxyMock(long indexId) {
        IndexProxy proxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexDescriptor descriptor = IndexingServiceTest.storeIndex(indexId, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)proxy.getDescriptor()).thenReturn((Object)descriptor);
        return proxy;
    }

    private static Matcher<? extends Throwable> causedBy(final Throwable exception) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                while (item != null) {
                    if (item == exception) {
                        return true;
                    }
                    item = item.getCause();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("exception caused by ").appendValue((Object)exception);
            }
        };
    }

    private String storedFailure() {
        ArgumentCaptor reason = ArgumentCaptor.forClass(String.class);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed((String)reason.capture());
        return (String)reason.getValue();
    }

    private static Answer<Void> waitForLatch(CountDownLatch latch) {
        return invocationOnMock -> {
            latch.await();
            return null;
        };
    }

    private static Answer<ResourceIterator<File>> newResourceIterator(File theFile) {
        return invocationOnMock -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)theFile));
    }

    private EntityUpdates addNodeUpdate(long nodeId, Object propertyValue) {
        return this.addNodeUpdate(nodeId, propertyValue, 7);
    }

    private EntityUpdates addNodeUpdate(long nodeId, Object propertyValue, int labelId) {
        return EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(new long[]{labelId}).added(this.prototype.schema().getPropertyId(), Values.of((Object)propertyValue)).build();
    }

    private IndexEntryUpdate<IndexDescriptor> add(long nodeId, Object propertyValue) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private IndexEntryUpdate<IndexDescriptor> add(long nodeId, Object propertyValue, IndexDescriptor index) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)index, (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexDescriptor ... rules) throws IOException {
        return this.newIndexingServiceWithMockedDependencies(populator, accessor, data, IndexingService.NO_MONITOR, rules);
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexingService.Monitor monitor, IndexDescriptor ... rules) throws IOException {
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (StorageEngineFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.multi_threaded_schema_index_population_enabled, (Object)false).set(GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name()).build();
        DefaultIndexProviderMap providerMap = (DefaultIndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap(IndexingServiceTest.buildIndexDependencies(this.indexProvider, IndexingServiceTest.fulltextProvider()), config));
        return (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)this.life.add((Lifecycle)this.scheduler)), (IndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, (Iterable)Iterators.loop((Iterator)Iterators.iterator((Object[])rules)), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)monitor, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (boolean)false));
    }

    private static DataUpdates withData(EntityUpdates ... updates) {
        return new DataUpdates(updates);
    }

    private static IndexDescriptor storeIndex(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("index_" + ruleId).materialise(ruleId);
    }

    private static IndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("constraint_" + ruleId).materialise(ruleId);
    }

    private static IndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor, long constraintId) {
        return IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("constraint_" + ruleId).materialise(ruleId).withOwningConstraintId(constraintId);
    }

    private IndexingService createIndexServiceWithCustomIndexMap(IndexMapReference indexMapReference) {
        return new IndexingService((IndexProxyCreator)Mockito.mock(IndexProxyCreator.class), (IndexProviderMap)Mockito.mock(IndexProviderMap.class), indexMapReference, (IndexStoreView)Mockito.mock(IndexStoreView.class), Collections.emptyList(), (IndexSamplingController)Mockito.mock(IndexSamplingController.class), (TokenNameLookup)this.nameLookup, (JobScheduler)Mockito.mock(JobScheduler.class), (SchemaState)Mockito.mock(SchemaState.class), (MultiPopulatorFactory)Mockito.mock(MultiPopulatorFactory.class), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, IndexingService.NO_MONITOR, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), false);
    }

    private static DependencyResolver buildIndexDependencies(IndexProvider ... providers) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies((Object[])providers);
        return dependencies;
    }

    private static IndexProvider mockIndexProviderWithAccessor(IndexProviderDescriptor descriptor) throws IOException {
        IndexProvider provider = IndexingServiceTest.mockIndexProvider(descriptor);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)indexAccessor);
        return provider;
    }

    private static IndexProvider mockIndexProvider(IndexProviderDescriptor descriptor) {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)descriptor);
        return provider;
    }

    private static IndexProvider fulltextProvider() {
        return IndexingServiceTest.mockIndexProvider(fulltextDescriptor);
    }

    private void onBothLogProviders(Consumer<AssertableLogProvider> logProviderAction) {
        logProviderAction.accept(this.internalLogProvider);
        logProviderAction.accept(this.userLogProvider);
    }

    private static class InMemoryNameLookup
    implements TokenNameLookup {
        private static final String DEFAULT_LABEL = "label";
        private static final String DEFAULT_PROPERTY = "property";
        private final HashMap<Integer, String> labels = new HashMap();
        private final HashMap<Integer, String> properties = new HashMap();

        private InMemoryNameLookup() {
        }

        public String labelGetName(int labelId) {
            return this.labels.getOrDefault(labelId, DEFAULT_LABEL);
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return null;
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return this.properties.getOrDefault(propertyKeyId, DEFAULT_PROPERTY);
        }

        void label(int labelId, String label) {
            this.labels.put(labelId, label);
        }

        void property(int propertyId, String property) {
            this.properties.put(propertyId, property);
        }
    }

    private static class TrackingIndexAccessor
    extends IndexAccessor.Adapter {
        private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);

        private TrackingIndexAccessor() {
        }

        public void drop() {
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.updater;
        }

        public IndexReader newReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public BoundedIterable<Long> newAllEntriesReader(long fromIdInclusive, long toIdExclusive) {
            throw new UnsupportedOperationException("Not required");
        }

        public ResourceIterator<File> snapshotFiles() {
            throw new UnsupportedOperationException("Not required");
        }
    }

    private static class DataUpdates
    implements Answer<StoreScan<IndexPopulationFailedKernelException>> {
        private final EntityUpdates[] updates;

        DataUpdates() {
            this.updates = new EntityUpdates[0];
        }

        DataUpdates(EntityUpdates[] updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(Visitor.class), (Visitor)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean())).thenAnswer((Answer)this);
        }

        public StoreScan<IndexPopulationFailedKernelException> answer(InvocationOnMock invocation) {
            final Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor = DataUpdates.visitor(invocation.getArgument(2));
            return new StoreScan<IndexPopulationFailedKernelException>(){
                private volatile boolean stop;

                public void run() throws IndexPopulationFailedKernelException {
                    for (EntityUpdates update : updates) {
                        if (this.stop) {
                            return;
                        }
                        visitor.visit((Object)update);
                    }
                }

                public void stop() {
                    this.stop = true;
                }

                public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
                }

                public PopulationProgress getProgress() {
                    return PopulationProgress.single((long)42L, (long)100L);
                }
            };
        }

        private static Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor(Object v) {
            return (Visitor)v;
        }

        public String toString() {
            return Arrays.toString(this.updates);
        }
    }

    private static class ControlledIndexPopulator
    extends IndexPopulator.Adapter {
        private final DoubleLatch latch;

        ControlledIndexPopulator(DoubleLatch latch) {
            this.latch = latch;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.latch.waitForAllToStart();
        }

        public void close(boolean populationCompletedSuccessfully) {
            this.latch.finish();
        }
    }
}

