/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class MultipleIndexPopulatorUpdatesTest {
    private final LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class, (Answer)Answers.RETURNS_MOCKS);

    MultipleIndexPopulatorUpdatesTest() {
    }

    @Test
    void updateForHigherNodeIgnoredWhenUsingFullNodeStoreScan() throws IndexPopulationFailedKernelException, IndexEntryConflictException {
        IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
        StorageReader reader = (StorageReader)Mockito.mock(StorageReader.class);
        Mockito.when((Object)reader.allocateNodeCursor()).thenReturn((Object)((StorageNodeCursor)Mockito.mock(StorageNodeCursor.class)));
        ProcessListenableNeoStoreIndexView storeView = new ProcessListenableNeoStoreIndexView(LockService.NO_LOCK_SERVICE, () -> reader);
        MultipleIndexPopulator indexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, this.logProvider, EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), indexStatisticsStore);
        storeView.setProcessListener(new NodeUpdateProcessListener(indexPopulator));
        IndexPopulator populator = MultipleIndexPopulatorUpdatesTest.createIndexPopulator();
        IndexUpdater indexUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        MultipleIndexPopulatorUpdatesTest.addPopulator(indexPopulator, populator, 1L, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})));
        indexPopulator.create();
        StoreScan storeScan = indexPopulator.indexAllEntities();
        storeScan.run();
        ((IndexUpdater)Mockito.verify((Object)indexUpdater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
    }

    private static IndexPopulator createIndexPopulator() {
        return (IndexPopulator)Mockito.mock(IndexPopulator.class);
    }

    private static void addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, long indexId, IndexPrototype prototype) {
        IndexDescriptor descriptor = prototype.withName("index_" + indexId).materialise(indexId);
        MultipleIndexPopulatorUpdatesTest.addPopulator(multipleIndexPopulator, descriptor, indexPopulator, (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class), (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }

    private static void addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        multipleIndexPopulator.addPopulator(indexPopulator, descriptor, flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private static class ListenableNodeScanViewNodeStoreScan<FAILURE extends Exception>
    extends StoreViewNodeStoreScan<FAILURE> {
        private final Listener<StorageNodeCursor> processListener;

        ListenableNodeScanViewNodeStoreScan(StorageReader storageReader, LockService locks, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, Listener<StorageNodeCursor> processListener) {
            super(storageReader, locks, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
            this.processListener = processListener;
        }

        public boolean process(StorageNodeCursor cursor) throws FAILURE {
            this.processListener.receive((Object)cursor);
            return super.process(cursor);
        }
    }

    private static class ProcessListenableNeoStoreIndexView
    extends NeoStoreIndexStoreView {
        private Listener<StorageNodeCursor> processListener;

        ProcessListenableNeoStoreIndexView(LockService locks, Supplier<StorageReader> storageReaderSupplier) {
            super(locks, storageReaderSupplier);
        }

        public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
            return new ListenableNodeScanViewNodeStoreScan<FAILURE>((StorageReader)this.storageEngine.get(), this.locks, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, this.processListener);
        }

        void setProcessListener(Listener<StorageNodeCursor> processListener) {
            this.processListener = processListener;
        }
    }

    private static class NodeUpdateProcessListener
    implements Listener<StorageNodeCursor> {
        private final MultipleIndexPopulator indexPopulator;
        private final LabelSchemaDescriptor index;

        NodeUpdateProcessListener(MultipleIndexPopulator indexPopulator) {
            this.indexPopulator = indexPopulator;
            this.index = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        }

        public void receive(StorageNodeCursor node) {
            if (node.entityReference() == 7L) {
                this.indexPopulator.queueConcurrentUpdate(IndexEntryUpdate.change((long)8L, (SchemaDescriptorSupplier)this.index, (Value)Values.of((Object)"a"), (Value)Values.of((Object)"b")));
            }
        }
    }
}

