/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.DoubleLatch;

class IndexSamplingJobTrackerTest {
    private static final long indexId11 = 0L;
    private static final long indexId12 = 1L;
    private static final long indexId22 = 2L;
    private final IndexSamplingConfig config = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    IndexSamplingJobTrackerTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.executorService.shutdownNow();
        this.jobScheduler.shutdown();
    }

    @Test
    void shouldNotRunASampleJobWhichIsAlreadyRunning() {
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, this.jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicInteger count = new AtomicInteger(0);
        IndexSamplingJob job = new IndexSamplingJob(){

            public void run() {
                count.incrementAndGet();
                latch.waitForAllToStart();
                latch.finish();
            }

            public long indexId() {
                return 1L;
            }
        };
        jobTracker.scheduleSamplingJob(job);
        jobTracker.scheduleSamplingJob(job);
        latch.startAndWaitForAllToStart();
        latch.waitForAllToFinish();
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void shouldDoNothingWhenUsedAfterBeingStopped() {
        JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, scheduler);
        jobTracker.stopAndAwaitAllJobs();
        jobTracker.scheduleSamplingJob((IndexSamplingJob)Mockito.mock(IndexSamplingJob.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{scheduler});
    }

    @Test
    void shouldStopAndWaitForAllJobsToFinish() throws Exception {
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, this.jobScheduler);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        WaitingIndexSamplingJob job1 = new WaitingIndexSamplingJob(0L, latch1);
        WaitingIndexSamplingJob job2 = new WaitingIndexSamplingJob(2L, latch1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job2);
        Future<?> stopping = this.executorService.submit(() -> {
            latch2.countDown();
            jobTracker.stopAndAwaitAllJobs();
        });
        latch2.await();
        Assertions.assertFalse((boolean)stopping.isDone());
        latch1.countDown();
        stopping.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)stopping.isDone());
        Assertions.assertNull(stopping.get());
        Assertions.assertTrue((boolean)job1.executed);
        Assertions.assertTrue((boolean)job2.executed);
    }

    private static class WaitingIndexSamplingJob
    implements IndexSamplingJob {
        final long indexId;
        final CountDownLatch latch;
        volatile boolean executed;

        WaitingIndexSamplingJob(long indexId, CountDownLatch latch) {
            this.indexId = indexId;
            this.latch = latch;
        }

        public long indexId() {
            return this.indexId;
        }

        public void run() {
            try {
                this.latch.await();
                this.executed = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

