/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
class GenericBlockBasedIndexPopulatorTest {
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(1L);
    private static final IndexDescriptor UNIQUE_INDEX_DESCRIPTOR = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("constrain").materialise(1L);
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    private IndexFiles indexFiles;

    GenericBlockBasedIndexPopulatorTest() {
    }

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.directory.homeDir()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, INDEX_DESCRIPTOR.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeExternalUpdateBothBeforeAndAfterScanCompleted() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            TextValue hakuna = Values.stringValue((String)"hakuna");
            TextValue matata = Values.stringValue((String)"matata");
            int hakunaId = 1;
            int matataId = 2;
            GenericBlockBasedIndexPopulatorTest.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, hakuna, hakunaId);
            populator.scanCompleted(PhaseTracker.nullInstance);
            GenericBlockBasedIndexPopulatorTest.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, matata, matataId);
            GenericBlockBasedIndexPopulatorTest.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)hakuna, hakunaId);
            GenericBlockBasedIndexPopulatorTest.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)matata, matataId);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScan() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate firstScanUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondScanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> GenericBlockBasedIndexPopulatorTest.lambda$shouldThrowOnDuplicatedValuesFromScan$0((BlockBasedIndexPopulator)populator, firstScanUpdate, secondScanUpdate));
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromExternalUpdates() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate firstExternalUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondExternalUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> GenericBlockBasedIndexPopulatorTest.lambda$shouldThrowOnDuplicatedValuesFromExternalUpdates$1((BlockBasedIndexPopulator)populator, firstExternalUpdate, secondExternalUpdate));
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate externalUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate scanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> GenericBlockBasedIndexPopulatorTest.lambda$shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates$2((BlockBasedIndexPopulator)populator, externalUpdate, scanUpdate));
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotThrowOnDuplicationsLaterFixedByExternalUpdates() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            Value unique = Values.of((Object)"unique");
            IndexEntryUpdate firstScanUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondScanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate externalUpdate = IndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value)duplicate, (Value)unique);
            populator.add(Collections.singleton(firstScanUpdate));
            try (IndexUpdater updater = populator.newPopulatingUpdater();){
                updater.process(externalUpdate);
            }
            populator.add(Collections.singleton(secondScanUpdate));
            populator.scanCompleted(PhaseTracker.nullInstance);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, unique, 1);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, duplicate, 2);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleEntriesOfMaxSize() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            IndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{LayoutTestUtil.generateStringValueResultingInSize(populator.layout, maxKeyValueSize)});
            Set<IndexEntryUpdate> updates = Collections.singleton(update);
            populator.add(updates);
            populator.scanCompleted(PhaseTracker.nullInstance);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, update.values()[0], 1);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowForEntriesLargerThanMaxSize() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        int maxKeyValueSize = populator.tree.keyValueSizeCap();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{LayoutTestUtil.generateStringValueResultingInSize(populator.layout, maxKeyValueSize + 1)});
        try {
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GenericBlockBasedIndexPopulatorTest.lambda$shouldThrowForEntriesLargerThanMaxSize$3(update, (BlockBasedIndexPopulator)populator));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Failed while trying to write to index, targetIndex=Index( 1, 'index', GENERAL BTREE, :Label1(property1), Undecided-0 ), nodeId=1"));
        }
        finally {
            populator.close(true);
        }
    }

    private static void assertHasEntry(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value entry, int expectedId) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleNodeValueClient valueClient = new SimpleNodeValueClient();
            IndexQuery.ExactPredicate exact = IndexQuery.exact((int)INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)entry);
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)valueClient, IndexOrder.NONE, false, new IndexQuery[]{exact});
            Assertions.assertTrue((boolean)valueClient.next());
            long id = valueClient.reference;
            Assertions.assertEquals((long)expectedId, (long)id);
        }
    }

    private static void externalUpdate(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, TextValue matata, int matataId) throws IndexEntryConflictException {
        try (IndexUpdater indexUpdater = populator.newPopulatingUpdater();){
            indexUpdater.process(IndexEntryUpdate.add((long)matataId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{matata}));
        }
    }

    private static void assertMatch(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value value, long id) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleNodeValueClient cursor = new SimpleNodeValueClient();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)cursor, IndexOrder.NONE, true, new IndexQuery[]{IndexQuery.exact((int)INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)value)});
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)id, (long)cursor.reference);
            Assertions.assertEquals((Object)value, (Object)cursor.values[0]);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    private GenericBlockBasedIndexPopulator instantiatePopulator(IndexDescriptor indexDescriptor) {
        Config config = Config.defaults();
        IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        SpaceFillingCurveConfiguration configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration((Config)config);
        GenericBlockBasedIndexPopulator populator = new GenericBlockBasedIndexPopulator(this.pageCache, this.fs, this.indexFiles, (IndexLayout)layout, IndexProvider.Monitor.EMPTY, indexDescriptor, spatialSettings, configuration, false, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), this.tokenNameLookup);
        populator.create();
        return populator;
    }

    private static /* synthetic */ void lambda$shouldThrowForEntriesLargerThanMaxSize$3(IndexEntryUpdate update, BlockBasedIndexPopulator populator) throws Throwable {
        Set<IndexEntryUpdate> updates = Collections.singleton(update);
        populator.add(updates);
        populator.scanCompleted(PhaseTracker.nullInstance);
    }

    private static /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates$2(BlockBasedIndexPopulator populator, IndexEntryUpdate externalUpdate, IndexEntryUpdate scanUpdate) throws Throwable {
        try (IndexUpdater updater = populator.newPopulatingUpdater();){
            updater.process(externalUpdate);
        }
        populator.add(Collections.singleton(scanUpdate));
        populator.scanCompleted(PhaseTracker.nullInstance);
    }

    private static /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromExternalUpdates$1(BlockBasedIndexPopulator populator, IndexEntryUpdate firstExternalUpdate, IndexEntryUpdate secondExternalUpdate) throws Throwable {
        try (IndexUpdater updater = populator.newPopulatingUpdater();){
            updater.process(firstExternalUpdate);
            updater.process(secondExternalUpdate);
        }
        populator.scanCompleted(PhaseTracker.nullInstance);
    }

    private static /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromScan$0(BlockBasedIndexPopulator populator, IndexEntryUpdate firstScanUpdate, IndexEntryUpdate secondScanUpdate) throws Throwable {
        populator.add(Collections.singleton(firstScanUpdate));
        populator.add(Collections.singleton(secondScanUpdate));
        populator.scanCompleted(PhaseTracker.nullInstance);
    }
}

