/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LayoutTestUtil {
    public static String generateStringResultingInSizeForIndexProvider(int size, GraphDatabaseSettings.SchemaIndex schemaIndex) {
        if (schemaIndex == GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10) {
            IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
            return LayoutTestUtil.generateStringResultingInSize(new GenericLayout(1, spatialSettings), size);
        }
        throw new UnsupportedOperationException("SchemaIndex " + schemaIndex + " is not supported.");
    }

    static <KEY extends NativeIndexKey<KEY>> Value generateStringValueResultingInSize(Layout<KEY, ?> layout, int size) {
        return Values.stringValue((String)LayoutTestUtil.generateStringResultingInSize(layout, size));
    }

    static <KEY extends NativeIndexKey<KEY>> String generateStringResultingInSize(Layout<KEY, ?> layout, int size) {
        String string;
        NativeIndexKey key = (NativeIndexKey)layout.newKey();
        key.initialize(0L);
        int stringLength = size;
        do {
            string = StringUtils.repeat((char)'A', (int)stringLength--);
            TextValue value = Values.stringValue((String)string);
            key.initFromValue(0, (Value)value, NativeIndexKey.Inclusion.NEUTRAL);
        } while (layout.keySize((Object)key) > size);
        Assert.assertEquals((long)size, (long)layout.keySize((Object)key));
        return string;
    }
}

