/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.ValueType;

class NativeIndexAccessorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexAccessorTests<KEY, VALUE> {
    private static final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final StandardConfiguration configuration = new StandardConfiguration();
    private final AccessorFactory<KEY, VALUE> accessorFactory = NativeIndexAccessorTest.genericAccessorFactory();
    private final ValueType[] supportedTypes = ValueType.values();
    private final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory = () -> new GenericLayout(1, spaceFillingCurveSettings);
    private final IndexCapability indexCapability = GenericNativeIndexProvider.CAPABILITY;

    NativeIndexAccessorTest() {
    }

    @Override
    NativeIndexAccessor<KEY, VALUE> makeAccessor() throws IOException {
        return this.accessorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.indexFiles, this.layout, RecoveryCleanupWorkCollector.immediate(), this.monitor, this.indexDescriptor, false, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }

    @Override
    IndexCapability indexCapability() {
        return this.indexCapability;
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)42, (int[])new int[]{666})).withName("index").materialise(0L), this.supportedTypes, 0.1);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.indexLayoutFactory.create();
    }

    private static AccessorFactory<GenericKey, NativeIndexValue> genericAccessorFactory() {
        return (pageCache, fs, storeFiles, layout, cleanup, monitor, descriptor, readOnly, tokenNameLookup) -> new GenericNativeIndexAccessor(pageCache, fs, storeFiles, layout, cleanup, monitor, descriptor, spaceFillingCurveSettings, (SpaceFillingCurveConfiguration)configuration, readOnly, tokenNameLookup);
    }

    @FunctionalInterface
    private static interface AccessorFactory<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        public NativeIndexAccessor<KEY, VALUE> create(PageCache var1, FileSystemAbstraction var2, IndexFiles var3, IndexLayout<KEY, VALUE> var4, RecoveryCleanupWorkCollector var5, IndexProvider.Monitor var6, IndexDescriptor var7, boolean var8, TokenNameLookup var9) throws IOException;
    }
}

